---
url: /dash-core-components/rangeslider
name: RangeSlider
description:
    "The dcc.RangeSlider component allows users to select a range of values between two pre-set values."
languages:
    - python
    - julia
    - r
    - fsharp
    - matlab
---

# ![](/assets/images/language_icons/r-lang_50px.svg) dcc.RangeSlider

`dcc.RangeSlider` is a component for rendering a range slider. Users interact with a `dcc.RangeSlider` by selecting areas on the *rail* or by dragging *handles*.

The points displayed on a `dcc.RangeSlider` are called `marks`. In Dash 2.1 and later, they are autogenerated if not explicitly provided or turned off.

## Examples

Find a few usage examples below.



### Simple RangeSlider Example

An example of a simple `dcc.RangeSlider` tied to a callback. The callback takes the `dcc.RangeSlider`'s currently selected range and outputs it to a `html.Div`.

{{example rangeslider_simple}}

`, `max` sets a maximum, and `step` defines the points for the `dcc.RangeSlider` between the `min` and the `max`.

`dcc.RangeSlider` accepts these three arguments as positional arguments, but you can also provide them as keyword arguments. Using keyword arguments, the same `dcc.RangeSlider` component code looks like this:

```python
dcc.RangeSlider(min=0, max=20, step=1, value=[5, 15], id='my-range-slider'),
```

### Auto Generated Marks

By default, the `dcc.RangeSlider` component adds `marks` if they are not specified, as in the example above. It uses the `min` and `max` and and the `marks` correspond to the `step` if you use one.

If you don't supply `step`, `RangeSlider` automatically calculates a step and adds around five marks. Labels for autogenerated marks are SI unit formatted.

{{example range_slider_without_step}}


### Turn Off Marks

You can turn off marks by setting `marks=None`:

{{example range_slider_turn_off_marks}}

### Custom Marks

You can also define custom marks. If `marks` are defined and `step` is set to `None` then the dcc.RangeSlider will only be
able to select values that have been predefined by the `marks`. Note that the default is
`step=1`, so you must explicitly specify `None` to get this behavior. `marks` is a `dict`
where the keys represent the numerical values and the values represent their labels.

{{example rangeslider_marks_steps}}

}}

### Marks and Steps

If slider {{fsharp `RangeSlider.Attr.marks` are defined and  is set to `NULL`
then the slider will only be able to select values that have been predefined by the .


{{example rangeslider_marks_steps}}

}}


### Included and Styling Marks

By default, `included=TRUE`, meaning the rail
trailing the handle will be highlighted. To have the handle act as a
discrete value, set `included=False`.
To style , include a style CSS attribute alongside the key value.

{{example rangeslider_included_marks}}


### Multiple Handles

To create multiple handles, define more values for .

{{example rangeslider_multiple_handles}}


### Pushable Handles

The  property is either a  or a numerical value.
The numerical value determines the minimum distance between
the handles. Try moving the handles around!

{{example rangeslider_pushable_handles}}


### Non-Crossing Handles

To prevent handles from crossing each other, set `FALSE`.

{{example rangeslider_cross_handles}}


### Non-Linear Slider and Updatemode

Create a logarithmic slider by setting  to be logarithmic and
adjusting the slider's output  in the callbacks. The 
property allows us to determine when we want a callback to be triggered.
The following example has  which means a callback is
triggered everytime the handle is moved.
Contrast the callback output with the first example on this page to see
the difference.

{{example rangeslider_nonlinear}}


### Tooltips

The  property can be used to display the current value. The `placement` parameter
 controls the position of the tooltip i.e. , , ,  and  is used, then
the tooltips will show always, otherwise it will only show when hovered upon.

{{example rangeslider_tooltip}}

#### Styling Tooltips

*New in Dash 2.15*

You can customize the style of tooltips with the `tooltip.style` parameter. This accepts a dictionary of styles to apply. In this example, we set the text color and font size.

{{example rangeslider_styles}}


#### Transforming Tooltip Values

*New in Dash 2.15*

You can transform the value displayed on a tooltip using a JavaScript function by specifying the function name with the `tooltip.transform` parameter. 

To make a custom function available in your app, add it to a file in your app's assets folder. The function needs to be available in the `window.dccFunctions` namespace.

In this example, we have a function that converts temperatures in Fahrenheit to Celsius. This function is saved in `assets/tooltip.js`:

```
window.dccFunctions = window.dccFunctions || {};
window.dccFunctions.temperatureInCelsius = function(value) {
     return ((value - 32) * 5/9).toFixed(2);
}
```

We then pass this function name to the `tooltip.transform` parameter:

{{example rangeslider_transform}}

#### Formatting Tooltips

*New in Dash 2.15*

You can customize the text displayed on tooltips using the `tooltip.template` parameter. This accepts a string, which must contain `{value}`. The `{value}` will be replaced with the string representation of the tooltip value, or with the value returned by a transform function if one was specified using `tooltip.transform` (see the previous section).

{{example rangeslider_format}}

***

{{reference dcc.RangeSlider}}
