---
url: /dash-bio/volcanoplot
name: VolcanoPlot
description:
    "Dash Bio is a component library
    dedicated to visualizing bioinformatics data."
icon_path: images/icons_v2/www (1).svg
languages:
  - python
  - r
  - matlab
thumbnail: 'volcanoplot.png'
---
# ![](/assets/images/language_icons/r-lang_50px.svg) dash_bio.VolcanoPlot Examples and Reference
See [VolcanoPlot in action](https://dash-gallery.plotly.host/dash-volcano-plot).

## VolcanoPlot

An example of a default VolcanoPlot component without any extra properties.

{{example defaultVolcano}}

## Customization

### Colors
Choose the colors of the scatter plot points, the highlighted points, the genome-wide line, and the effect size lines.

{{example volcanoColor}}

### Point Sizes And Line Widths
Change the size of the points on the scatter plot, and the widths of the effect lines and genome-wide line.

{{example volcanoSize}}

{{reference dash_bio.VolcanoPlot}}

## Example Data

- https://github.com/plotly/datasets/blob/master/Dash_Bio/Chromosomal/volcano_data1.csv
- [Differential gene expression analysis for microbiome skin treatment](https://springernature.figshare.com/articles/dataset/Additional_file_5_of_A_mixed_community_of_skin_microbiome_representatives_influences_cutaneous_processes_more_than_individual_members/13632969/1)
- [Differentially expressed genes between animals resistant and susceptible to amoebic gill disease in Atlantic salmon](https://springernature.figshare.com/articles/dataset/Additional_file_2_of_Characterising_the_mechanisms_underlying_genetic_resistance_to_amoebic_gill_disease_in_Atlantic_salmon_using_RNA_sequencing/12050985/1)
- [Stratified gene expression analysis comparing estrogen-receptor-positive (ER+) premenopausal (preM) and Normal groups in The Cancer Genome Atlas (TCGA)](https://springernature.figshare.com/articles/dataset/Additional_file_4_of_The_molecular_landscape_of_premenopausal_breast_cancer/4470440/1)
- [Identification of potential biomarkers to differentially diagnose solid pseudopapillary tumors and pancreatic malignancies via a gene regulatory network](https://springernature.figshare.com/articles/dataset/MOESM4_of_Identification_of_potential_biomarkers_to_differentially_diagnose_solid_pseudopapillary_tumors_and_pancreatic_malignancies_via_a_gene_regulatory_network/4463063/1)
