---
url: /dash-daq
name: Overview
breadcrumb: Dash DAQ
description:
    "Beautifully styled technical components for
    data acquisition, monitoring, and engineering
    applications."
icon: video-player.svg
languages:
    - python
    - julia
---

# ![](/assets/images/language_icons/r-lang_50px.svg) Dash DAQ

Dash is a web application framework that provides pure Python abstraction
around HTML, CSS, and JavaScript.

Dash DAQ comprises a robust set of controls that make it simpler to
integrate data acquisition and controls into your Dash applications.

The source is on GitHub at [plotly/dash-daq](https://github.com/plotly/dash-daq).

These docs are using version {{eval daq.__version__}}.


```
||julia
```julia
>julia using Pkg
>julia Pkg.status("DashDaq")
0.5.0
```
}}

------------------------

### <dccLink href="/dash-daq/booleanswitch" children = "BooleanSwitch"/>

{{example boolean-switch}}

**<dccLink href="/dash-daq/booleanswitch" children = "More BooleanSwitch Examples and Reference"/>**

------------------------

### <dccLink href="/dash-daq/colorpicker" children = "ColorPicker"/>

{{example color-picker}}

**<dccLink href="/dash-daq/colorpicker" children = "More ColorPicker Examples and Reference"/>**

------------------------

### <dccLink href="/dash-daq/gauge" children = "Gauge"/>

{{example gauge}}

**<dccLink href="/dash-daq/gauge" children = "More Gauge Examples and Reference"/>**

------------------------

### <dccLink href="/dash-daq/graduatedbar" children = "GraduatedBar"/>

{{example graduated-bar}}

**<dccLink href="/dash-daq/graduatedbar" children = "More GraduatedBar Examples and Reference"/>**

------------------------

### <dccLink href="/dash-daq/indicator" children = "Indicator"/>

{{example indicator}}

**<dccLink href="/dash-daq/indicator" children = "More Indicator Examples and Reference"/>**

------------------------

### <dccLink href="/dash-daq/joystick" children = "Joystick"/>

{{example joystick}}

**<dccLink href="/dash-daq/joystick" children = "More Joystick Examples and Reference"/>**

------------------------

### <dccLink href="/dash-daq/knob" children = "Knob"/>

{{example knob}}

**<dccLink href="/dash-daq/knob" children = "More Knob Examples and Reference"/>**

------------------------

### <dccLink href="/dash-daq/leddisplay" children = "LEDDisplay"/>

{{example LED-display}}

**<dccLink href="/dash-daq/leddisplay" children = "More LEDDisplay Examples and Reference"/>**

------------------------

### <dccLink href="/dash-daq/numericinput" children = "NumericInput"/>

{{example numeric-input}}

**<dccLink href="/dash-daq/numericinput" children = "More NumericInput Examples and Reference"/>**

------------------------

### <dccLink href="/dash-daq/powerbutton" children = "PowerButton"/>

{{example power-button}}

**<dccLink href="/dash-daq/powerbutton" children = "More PowerButton Examples and Reference"/>**

------------------------

### <dccLink href="/dash-daq/precisioninput" children = "PrecisionInput"/>

{{example precision-input}}

**<dccLink href="/dash-daq/precisioninput" children = "More PrecisionInput Examples and Reference"/>**

------------------------

### <dccLink href="/dash-daq/slider" children = "Slider"/>

{{example slider}}

**<dccLink href="/dash-daq/slider" children = "More Slider Examples and Reference"/>**

------------------------

### <dccLink href="/dash-daq/stopbutton" children = "StopButton"/>

{{example stop-button}}

**<dccLink href="/dash-daq/stopbutton" children = "More StopButton Examples and Reference"/>**

------------------------

### <dccLink href="/dash-daq/tank" children = "Tank"/>

{{example tank}}

**<dccLink href="/dash-daq/tank" children = "More Tank Examples and Reference"/>**

------------------------

### <dccLink href="/dash-daq/thermometer" children = "Thermometer"/>

{{example thermometer}}

**<dccLink href="/dash-daq/thermometer" children = "More Thermometer Examples and Reference"/>**

------------------------

### <dccLink href="/dash-daq/toggleswitch" children = "ToggleSwitch"/>

{{example toggle-switch}}

**<dccLink href="/dash-daq/toggleswitch" children = "More ToggleSwitch Examples and Reference"/>**

------------------------

### <dccLink href="/dash-daq/darkthemeprovider" children = "DarkThemeProvider"/>

{{example dark-theme-provider}}

**<dccLink href="/dash-daq/darkthemeprovider" children = "More DarkThemeProvider Examples and Reference"/>**
