---
url: /dash-bio
name: Overview
breadcrumb: Dash Bio
description:
    "Dash Bio is a component library
    dedicated to visualizing bioinformatics data."
icon_path: images/icons_v2/www (1).svg
languages:
  - python
  - julia
  - r
  - matlab
---
# ![](/assets/images/language_icons/r-lang_50px.svg) Dash Bio
To install, run the following commands below in your R Console:

```
>remotes::install_github("plotly/dash-bio")
>library(dashBio)
```

Dash is a web application framework that provides pure R abstraction
around HTML, CSS, and JavaScript.

Dash Bio is a suite of bioinformatics components that make it simpler to
analyze and visualize bioinformatics data and interact with them in a Dash
application.

The source can be found on GitHub at [plotly/dash-bio](https://github.com/plotly/dash-bio).

These docs are using Dash Bio version 1.0.0.




### [AlignmentChart](https://dash.plotly.com/dash-bio/alignmentchart)
An alignment chart.

{{example alignment-chart}}

[More AlignmentChart Examples and Reference](https://dash.plotly.com/dash-bio/alignmentchart)

### [Circos](https://dash.plotly.com/dash-bio/circos)
A circular ideogram with arcs representing links between genes

{{example circos}}

[More Circos Examples and Reference](https://dash.plotly.com/dash-bio/circos)

### [Clustergram](https://dash.plotly.com/dash-bio/clustergram)
A heatmap with dendrograms to display clustering of data such as gene expression data.

{{example clustergram}}

[More Clustergram Examples and Reference](https://dash.plotly.com/dash-bio/clustergram)

### [FornaContainer](https://dash.plotly.com/dash-bio/fornacontainer)
A secondary structure visualization for RNA molecules.

{{example forna-container}}

[More FornaContainer Examples and Reference](https://dash.plotly.com/dash-bio/fornacontainer)

### [Ideogram](https://dash.plotly.com/dash-bio/ideogram)
A visual representation and analysis tool for chromosome bands.

{{example ideogram}}

[More Ideogram Examples and Reference](https://dash.plotly.com/dash-bio/ideogram)

### [Igv](https://dash.plotly.com/dash-bio/igv)
A visual representation and analysis tool for chromosome bands.

{{example igv}}

[More Igv Examples and Reference](https://dash.plotly.com/dash-bio/igv)

### [Jsme](https://dash.plotly.com/dash-bio/jsme)
Molecule editor that supports drawing and editing of molecules and reactions.

{{example jsme}}

[More Jsme Examples and Reference](https://dash.plotly.com/dash-bio/jsme)

### [ManhattanPlot](https://dash.plotly.com/dash-bio/manhattanplot)
A plot that can be used to display the results of genomic studies sorted out by chromosome. Perfect for Genome Wide Association Studies (GWAS).

{{example manhattan-plot}}

[More ManhattanPlot Examples and Reference](https://dash.plotly.com/dash-bio/manhattanplot)

### [Molecule2dViewer](https://dash.plotly.com/dash-bio/molecule2dviewer)
A 2D rendering of molecular structures.

{{example molecule-2d-viewer}}

[More Molecule2dViewer Examples and Reference](https://dash.plotly.com/dash-bio/molecule2dviewer)

### [Molecule3dViewer](https://dash.plotly.com/dash-bio/molecule3dviewer)
A 3D visualization of biomolecular structures.

{{example molecule-3d-viewer}}

[More Molecule3dViewer Examples and Reference](https://dash.plotly.com/dash-bio/molecule3dviewer)

### [NeedlePlot](https://dash.plotly.com/dash-bio/needleplot)
A combination of a bar chart and a scatter plot, for data that are both categorical and continuous.

{{example needle-plot}}

[More NeedlePlot Examples and Reference](https://dash.plotly.com/dash-bio/needleplot)

### [NglMoleculeViewer](https://dash.plotly.com/dash-bio/nglmoleculeviewer)
A comprehensive 3D molecule visualizer for visualizing multiple molecules and chains in a variety of representations.

{{example ngl-molecule-viewer}}

[More NglMoleculeViewer Examples and Reference](https://dash.plotly.com/dash-bio/nglmoleculeviewer)

### [OncoPrint](https://dash.plotly.com/dash-bio/oncoprint)
A chart that can be used to visualize multiple genomic alternations with an interactive heatmap.

{{example onco-print}}

[More OncoPrint Examples and Reference](https://dash.plotly.com/dash-bio/oncoprint)

### [Pileup](https://dash.plotly.com/dash-bio/pileup)
An interactive in-browser track viewer.

{{example pileup}}

[More Pileup Examples and Reference](https://dash.plotly.com/dash-bio/pileup)

### [SequenceViewer](https://dash.plotly.com/dash-bio/sequenceviewer)
A sequence viewer.

{{example sequence-viewer}}

[More SequenceViewer Examples and Reference](https://dash.plotly.com/dash-bio/sequenceviewer)

### [Speck](https://dash.plotly.com/dash-bio/speck)
A 3D WebGL molecule viewer.

{{example speck}}

[More Speck Examples and Reference](https://dash.plotly.com/dash-bio/speck)

### [VolcanoPlot](https://dash.plotly.com/dash-bio/volcanoplot)
A graph that can be used to identify clinically meaningful markers in genomic experiments.

{{example volcano-plot}}

[More VolcanoPlot Examples and Reference](https://dash.plotly.com/dash-bio/volcanoplot)
