library(dash)
library(dashCoreComponents)
library(dashHtmlComponents)
library(dashBio)
library(heatmaply)
library(data.table)

df = read.table("https://git.io/clustergram_mtcars.tsv",
                        skip = 4, sep ="	",  row.names = 1, header = TRUE)

dccGraph(figure = heatmaply(
    df,
    row_labels = list(row.names(data)),
    hide_labels = list("row"),
    column_labels = as.list(colnames(data)),
    color_threshold = list(
        "row" = 250,
        "col" = 700
    ),
    height = 800,
    width = 700,
    display_ratio=list(0.1, 0.7)
))
