app <- Dash$new()

library(readr)
library(dashBio)

fasta_str = "MALWMRLLPLLALLALWGPDPAAAFVNQHLCGSHLVEALYLVCGERGFFYTPKTRREAED
LQVGQVELGGGPGAGSLQPLALEGSLQKRGIVEQCCTSICSLYQLENYCN"

app$layout(htmlDiv(list(
    dashbioSequenceViewer(
        id = 'default-sequence-viewer',
        sequence = fasta_str
    ),
    htmlDiv(id = 'default-sequence-viewer-output')
)))

app$callback(
    output(id = "default-sequence-viewer-output", property = "children"),
    params = list(
        input(id = 'default-sequence-viewer', property = "mouseSelection")
    ),
    update_output <- function(value) {
        if ((length(value) == 0)| is.null(value[[1]])) {
            return("There is no mouse selection.")
        }
        else{
            return(sprintf("The mouse selection is %s", value$selection))
        }
    }
)

app$run_server()