---
url: /introduction
name: Introduction
description:
    "A short introduction to Dash."
icon: line-chart.svg
languages:
  - python
  - julia
  - r
  - fsharp
  - matlab
---

# ![](/assets/images/language_icons/matlab_50px.svg) Introduction to Dash

Downloaded 800,000 times per month, Dash is the original low-code framework
for rapidly building data apps in Python, R, Julia, and F# (experimental).

Written on top of Plotly.js and React.js,
Dash is ideal for building and deploying data apps
with customized user interfaces.
It's particularly suited for anyone who works with data.

Through a couple of simple patterns, Dash abstracts away all of the
technologies and protocols that are required to build a full-stack
web app with interactive data visualization.

Dash is simple enough that you can bind a user interface
to your code in less than 10 minutes.

{{oss {{dash-club}} }}

Dash apps are rendered in the web browser. You can deploy your apps
to VMs or Kubernetes clusters and then share them through URLs.
Since Dash apps are viewed in the web browser, Dash is inherently
cross-platform and mobile ready.

There is a lot behind the framework. To learn more about how the original Dash was built
and what motivated Dash, read our [announcement letter](https://medium.com/@plotlygraphs/introducing-dash-5ecf7191b503).

{{oss

Dash is an open source library released under the permissive MIT license.
[Plotly](https://plotly.com) develops Dash and also offers a [platform for writing and deploying Dash
apps in an enterprise environment](https://plotly.com/dash/).
If you're interested, [please get in touch](https://plotly.com/get-demo/).

>
>Write, deploy, and scale Dash apps on Dash Enterprise.
>
>[Learn more](https://plotly.com/dash/) | [Pricing](https://plotly.com/get-pricing/) | [Dash Enterprise Demo](https://plotly.com/get-demo/) | [Dash Enterprise Overview](https://plotly.com/dash/)

}}

