---
url: /loading-states
name: Loading States
description: 'Getting the loading state of a component and adding a loading component'
icon: wall-clock.svg
languages:
    - python
---

# ![](/assets/images/language_icons/matlab_50px.svg) Loading States


## Loading Component

The `dcc.Loading` component displays a spinner when the components it wraps are in a loading state.
Internally, Dash updates the `dcc.Loading` component when the loading state of the components it wraps changes.

{{example loading}}

Please also check out the docs for the [Loading component](/dash-core-components/loading) for more information on how to use the Loading component.

## Check Loading States From Components

Aside from using the [Loading component](/dash-core-components/loading), you can check if a certain component
(either from  or ) is loading by checking the
`data-dash-is-loading` attribute set on that component's HTML output. This means that
you can target those components yourself with CSS, and create your own custom loading
for them. Here's an example of what that could look like:

{{example loading_custom}}

You could target all components in the layout above that are loading using the following CSS:

```css
*[data-dash-is-loading="true"]{
    visibility: hidden;
}
*[data-dash-is-loading="true"]::before{
    content: "Loading...";
    display: inline-block;
    color: magenta;
    visibility: visible;
}
```

You can also target any other HTML attributes using CSS.
To target a specific class use the following CSS:

```css
*[class="output-example-loading"][data-dash-is-loading="true"]{
    visibility: hidden;
}
*[class="output-example-loading"][data-dash-is-loading="true"]::before{
    content: "Loading...";
    display: inline-block;
    color: magenta;
    visibility: visible;
}
```