---
url: /datatable
name: Overview
description:
    "`dash_table.DataTable` is an interactive table that supports rich styling,
    conditional formatting, editing, sorting, filtering, and more."
breadcrumb: "Dash DataTable"
icon: dashboard.svg
languages:
  - python
  - julia
  - matlab
---

# ![](/assets/images/language_icons/matlab_50px.svg) Dash DataTable

Dash DataTable (`dash.dash_table.DataTable`) is an interactive table component designed for viewing, editing, and exploring large datasets.

This component was written from scratch in React.js specifically
for the Dash community. Its API was designed to be ergonomic
and its behavior is completely customizable through its properties.
DataTable is rendered with standard, semantic HTML `<table/>` markup,
which makes it accessible, responsive, and easy to style.

Import DataTable with:
```py
from dash import dash_table
```





## Quickstart

{{tab Dash open-source
{{example simple}}
||tab
Dash Enterprise Design Kit
{{python
```python
from dash import Dash, dash_table
import pandas as pd
import dash_design_kit as ddk

df = pd.read_csv('https://git.io/Juf1t')

app = Dash()

app.layout = ddk.App(show_editor=True, children=[
    ddk.DataTable(
       id='table',
       columns=[{"name": i, "id": i} for i in df.columns],
       data=df.to_dict('records'),
       editable=True
   )
])

if __name__ == '__main__':
    app.run(debug=True)
```
Default Theme

![Default Theme](/assets/images/ddk/table-default.png)

Neptune Theme

![Neptune Theme](/assets/images/ddk/table-neptune.png)

Miller Theme

![Miller Theme](/assets/images/ddk/table-miller.png)

Mercury Theme

![Mercury Theme](/assets/images/ddk/table-mercury.png)

Design Kit Theme Editor

![Design Kit Theme Editor](/assets/images/ddk/theme-editor.png)

}}
}}

The `data` and `columns` properties are the first two arguments of `dash_table.DataTable`.
You can set these with <dccLink href="/component-argument-order" children = "positional or keyword arguments"/>. The following examples define the same DataTable:

```python
dash_table.DataTable(
    df.to_dict('records'),
    [{"name": i, "id": i} for i in df.columns]
)
```

```python
dash_table.DataTable(
    data=df.to_dict('records'),
    columns=[{"name": i, "id": i} for i in df.columns]
)
```

You can also omit `columns`. When no `columns` argument is provided, columns are auto-generated based on the first row in `data`.

```python
dash_table.DataTable(df.to_dict('records'))
```

## Table with Click Callback

[![replit](/assets/images/replit.svg)](https://replit.com/@jackparmer1/Dash-Table-Callbacks#main.py)
&nbsp;&nbsp;&nbsp;&nbsp;
[![colab](/assets/images/colab.svg)](https://colab.research.google.com/drive/12qVEDF-qPaoISxfvniQ8Ue79xEAi94kT?usp=sharing)
&nbsp;&nbsp;&nbsp;&nbsp;
[![databricks](/assets/images/databricks.svg)](https://plotly.com/dash/databricks-integration/)

{{example simple_callback}}

{{oss {{dash-club}} }}

## User Guide

<dccLink href="/datatable/reference" children="Reference"/>

A comprehensive list of all of the DataTable properties.

<dccLink href="/datatable/height" children="DataTable Height"/>

How to set the height of the DataTable. Examples include how to set the height with vertical scroll, pagination, virtualization, and fixed headers.

<dccLink href="/datatable/width" children="DataTable Width & Column Width"/>


How to set the width of the table and the columns. Examples include how to handle word wrapping, cell clipping, horizontal scroll, fixed columns, and more.

<dccLink href="/datatable/style" children="Styling"/>

The style of the DataTable is highly customizable. This chapter includes examples for:

- Displaying multiple rows of headers
- Text alignment
- Styling the table as a list view
- Changing the colors (including a dark theme!)

<dccLink href="/datatable/conditional-formatting" children="Conditional Formatting"/>

Several examples of how to highlight certain cells, rows, or columns based on their value or state.

<dccLink href="/datatable/data-formatting" children="Number Formatting"/>

Several examples of how to format and localize numbers.

<dccLink href="/datatable/interactivity" children="Sorting, Filtering, Selecting, and Paging Natively"/>

The DataTable is interactive. This chapter demonstrates the interactive features of the table and how to wire up these interations to Python callbacks. These actions include:

- Paging
- Selecting Rows
- Sorting Columns
- Filtering Data

<dccLink href="/datatable/tooltips" children="DataTable Tooltips"/>

Display tooltips on data and header rows, conditional tooltips, define tooltips for each cell, customize behavior.

<dccLink href="/datatable/callbacks" children="Python-Driven Filtering, Paging, Sorting"/>

In Part 3, the paging, sorting, and filtering was done entirely clientside (in the browser). This means that you need to load all of the data into the table up-front. If your data is large, then this can be prohibitively slow. In this chapter, you'll learn how to write your own filtering, sorting, and paging backends in Python with Dash. We'll do the data processing with Pandas but you could write your own routines with SQL or even generate the data on the fly!

<dccLink href="/datatable/editable" children="Editable DataTable"/>

The DataTable is editable. Like a spreadsheet, it can be used as an input for controlling models with a variable number of inputs. This chapter includes recipes for:

- Determining which cell has changed
- Filtering out null values
- Adding or removing columns
- Adding or removing rows
- Ensuring that a minimum set of rows are visible
- Running Python computations on certain columns or cells

<dccLink href="/datatable/typing" children="Typing and User Input Processing"/>

In this chapter, you'll learn how to configure the table to

- assign the column type
- change the data presentation
- change the data formatting
- validate or coerce user data input
- apply default behavior for valid and invalid data

<dccLink href="/datatable/dropdowns" children="Dropdowns Inside DataTable"/>

Cells can be rendered as editable Dropdowns. This is our first stake in bringing a full typing system to the table. Rendering cells as dropdowns introduces some complexity in the markup and so there are a few limitations that you should be aware of.

<dccLink href="/datatable/virtualization" children="Virtualization"/>

Examples using DataTable virtualization.

<dccLink href="/datatable/filtering" children="Filtering Syntax"/>

An explanation and examples of filtering syntax for both frontend and backend filtering in the DataTable.
