%%%%%%%%%
% app.m %
%%%%%%%%%

terminate(pyenv);
clearvars;

myTabs = Dcc('Tabs', {...
    'children', {...
        Dcc('Tab', {'label', '1', 'value', 'tab-1'}),...
        Dcc('Tab', {'label', '2', 'value', 'tab-2'})},...
    'id', 'tabs-styled-with-props',...
    'value', 'tab-1',...
    'colors', struct(...
        'border', 'white',...
        'primary', 'gold',...
        'background', 'cornsilk')});
        

myDiv = Html('Div', {'id', 'tabs-content-props'});


components = {myTabs, myDiv};

% Callbacks
args = {argsOut('tabs-content-props', 'children'),...
    argsIn('tabs-styled-with-props', 'value')};
handle = 'render_content';

callbackDat = {args, handle};

% Start app
startDash(components, 8057, callbackDat, 'SOLAR');

%%%%%%%%%%%%%%%%%%%%
% render_content.m %
%%%%%%%%%%%%%%%%%%%%

function outDiv = render_content(tab)
    if strcmp(tab, 'tab-1')        
        H3 = Html('H3', {'Tab content 1'});
    elseif strcmp(tab, 'tab-2')
        H3 = Html('H3', {'Tab content 2'});
    end
    outDiv = Html('Div', {H3});
    outDiv = plotlyJsonEncoder(outDiv);
end