%%%%%%%%%
% app.m %
%%%%%%%%%

terminate(pyenv);
clearvars;

tab1 = Dcc('Tab', {...
    'label', 'Tab one',...
    'value', 'tab-1',...
    'className', 'custom-tab',...
    'selected_className', 'custom-tab--selected'});

tab2 = Dcc('Tab', {...
    'label', 'Tab two',...
    'value', 'tab-2',...
    'className', 'custom-tab',...
    'selected_className', 'custom-tab--selected'});

tab3 = Dcc('Tab', {...
    'label', 'Tab three, multiline',...
    'value', 'tab-3',...
    'className', 'custom-tab',...
    'selected_className', 'custom-tab--selected'});

tab4 = Dcc('Tab', {...
    'label', 'Tab four',...
    'value', 'tab-4',...
    'className', 'custom-tab',...
    'selected_className', 'custom-tab--selected'});

myTabs = Dcc('Tabs', {...
    'children', {tab1, tab2, tab3, tab4},...
    'id', 'tabs-with-classes',...
    'value', 'tab-2',...
    'parent_className', 'custom-tabs',...
    'className', 'custom-tabs-container'});
        

myDiv = Html('Div', {'id', 'tabs-content-classes'});


components = {myTabs, myDiv};

% Callbacks
args = {argsOut('tabs-content-classes', 'children'),...
    argsIn('tabs-with-classes', 'value')};
handle = 'render_content';

callbackDat = {args, handle};

% Start app
startDash(components, 8057, callbackDat, 'DARKLY');

%%%%%%%%%%%%%%%%%%%%
% render_content.m %
%%%%%%%%%%%%%%%%%%%%

function outDiv = render_content(tab)
    if strcmp(tab, 'tab-1')        
        H3 = Html('H3', {'Tab content 1'});
    elseif strcmp(tab, 'tab-2')
        H3 = Html('H3', {'Tab content 2'});
    elseif strcmp(tab, 'tab-3')
        H3 = Html('H3', {'Tab content 3'});
    elseif strcmp(tab, 'tab-4')
        H3 = Html('H3', {'Tab content 4'});
    end
    outDiv = Html('Div', {H3});
    outDiv = plotlyJsonEncoder(outDiv);
end
