---
url: /dash-core-components/radioitems
name: RadioItems
description:
    "The dcc.RadioItems component renders a set of radio buttons for single-option selection from multiple choices."
languages:
    - python
    - julia
    - fsharp
    - matlab
---
# ![](/assets/images/language_icons/matlab_50px.svg) dcc.RadioItems

`dcc.RadioItems` is a component for rendering a set of radio (or option) buttons. Users can select one option from the set.
See [Checklist](/dash-core-components/checklist)
for selecting multiple options at a time, and
[Dropdown](/dash-core-components/dropdown) for
a more compact view.

## Examples

Find a few usage examples below.



### Basic RadioItems

` component in that order.}}

{{example radioitems}}

### Horizontal Options



{{example radioitems_styled_label}}

`. There are multiple ways to set `options`. The following examples define the same RadioItems component:

```python
dcc.RadioItems(['New York City', 'Montreal', 'San Francisco'], 'Montreal')
```

```python
dcc.RadioItems(
   options=['New York City', 'Montreal', 'San Francisco'],
   value='Montreal'
)
```

```python
dcc.RadioItems(
   options=[
       {'label': 'New York City', 'value': 'New York City'},
       {'label': 'Montreal', 'value': 'Montreal'},
       {'label': 'San Francisco', 'value': 'San Francisco'},
   ],
   value='Montreal'
)
```

```python
dcc.RadioItems(
   options={
        'New York City': 'New York City',
        'Montreal': 'Montreal',
        'San Francisco': 'San Francisco'
   },
   value='Montreal'
)
```

In these examples, the option's label (what the user sees) and the value (what's passed into the callback) are equivalent. Often it is helpful for these to be separate so that you can easily change the label without changing the callback logic that uses the value:

```
dcc.RadioItems(
   options={
        'NYC': 'New York City',
        'MTL': 'Montreal',
        'SF': 'San Francisco'
   },
   value='MTL'
)
```

Options provided as a single dictionary render in no particular order in the browser.
Providing a list that contains a dictionary for each option ensures the options render in the order provided.

```
dcc.RadioItems(
   options=[
       {'label': 'New York City', 'value': 'NYC'},
       {'label': 'Montreal', 'value': 'MTL'},
       {'label': 'San Francisco', 'value': 'SF'},
   ],
   value='MTL'
)
```

> Note: Versions of Dash before 2.1 only support keyword arguments for `options` and `value`, and also `options` must be provided as a list of dictionaries.

### Disable Options

{{example radio_items_disabled}}

### Flexible Data Types

We've seen how `options` can be set using a list, a dictionary, or a list of dictionaries. `options` also accepts Pandas and NumPy data structures.

In this example, we use the DataFrame's columns (`df.columns`) as the `options`.

{{example radioitems_pandas_columns}}

Here, we set `options` with `df.nation.unique()`. This Pandas method returns unique values in the `nation` column. By passing it to `options`, our RadioItems component displays all unique values in that column.

{{example radioitems_pandas_unique}}

### Components as Option Labels

> This feature is available in Dash 2.5 and later.

In previous examples, we've set option labels as strings. You can also use Dash components as option labels.
In this example, each label is a list of components containing an `html.Img` and text in an `html.Span`.

{{example radioitems_components_as_props}}

### Styling Components as Option Labels

> This feature is available in Dash 2.5 and later.

You can also style labels by using `html.Div` components for each label and then setting styles using the `style` property:

{{example radioitems_components_as_props_style}}

}}

***

{{reference dcc.RadioItems}}
