---
url: /dash-core-components/download
name: Download
description:
    "dcc.Download allows users to directly download files like spreadsheets, images, and text files from your app, notifying you when data changes."
languages:
    - python
---
# ![](/assets/images/language_icons/matlab_50px.svg) dcc.Download

With the `dcc.Download` component, you can allow users to directly download files from your app. These files include (but are not limited to) spreadsheets, images, text files, etc. `dcc.Download` opens a download dialog when the `data` property changes.

Note that the following examples make use of the `prevent_initial_call` attribute to prevent the callbacks from being triggered when the app inputs are initially rendered. See <dccLink href="/advanced-callbacks" children="Advanced Callbacks"/> for more details.

## Examples

Find a few usage examples below.



### Downloading Content as Strings

Here is an example of downloading content as a string, while showing the raw JSON:

{{example download_text}}

### Downloading a Dataframe as a CSV file

For downloading dataframes, the many  export methods are supported. Below we are downloading a dataframe as a CSV:

{{example download_csv}}

### Downloading a Dataframe as an Excel file

To download a dataframe as an Excel file with Pandas, add `xlsxwriter` or `openpyxl` as an app dependency:

{{example download_excel}}

### Downloading Images

To download a file from disk, use `dcc.send_file`, taking care to specify the file path.

{{example download_image}}

------------------------

{{reference dcc.Download}}
