---
url: /dash-bio/pileup
name: Pileup
description:
    "Dash Bio is a component library
    dedicated to visualizing bioinformatics data."
icon_path: images/icons_v2/www (1).svg
languages:
  - python
  - matlab
thumbnail: 'pileup.png'
---

# ![](/assets/images/language_icons/matlab_50px.svg) dash_bio.Pileup Examples and Reference
see [Pileup in action](https://dash-gallery.plotly.host/dash-pileup).

## Pileup

An example of a default Pileup component without any extra properties.

{{example defaultPileup}}

## Customization

### Genome
Select a genome by specifying a reference label (e.g. "hg19", "mm10"), and a url pointing to a [TwoBit data file](http://genome.ucsc.edu/FAQ/FAQformat.html#format7). TwoBit files can be found in the [UCSC Genome Browser](https://hgdownload.soe.ucsc.edu/downloads.html), or can be remotely staged elsewhere.The Pileup component also requires a genomic range object that specifies the contig, start, and end position to be visualized.

{{example pileupGnome}}

### Tracks
Add tracks with the `tracks` property of a Pileup component to view additional data types and sources. Tracks can display genomic coverage, features, variants, and reads.
Each track in a Pileup component requires a visualization type (`viz`) and a data source (`source`).

#### Pileup Data Sources
Each data source has its own set of required keys. Below, we enumerate the available data source types:
- `bam` : requires `'sourceOptions': {'url':, URL.bam 'indexUrl': URL.bam.bai}`
- `alignmentJson` : requires `'sourceOptions': {GA4GH_JSON_STRING}`
- `variantJson` : requires `'sourceOptions': {GA4GH_JSON_STRING}`
- `featureJson` : requires `'sourceOptions': {GA4GH_JSON_STRING}`
- `idiogramJson` : requires `'sourceOptions': {JSON_STRING}`
- `vcf` : requires `'sourceOptions': {'url':, URL.vcf }`
- `bigBed` : requires `'sourceOptions': {'url':, URL.bb }`

#### Pileup Visualization Types
The Pileup component supports the following visualizations:
- `coverage` : requires `alignmentJson`, `bam`, or `featureJson` source
- `genes` : requires `bigBed` source
- `features` : requires `featureJson` or `bigBed` source
- `variants` : requires a `vcf` or `variantJson` data source
- `genotypes` : requires a `vcf` or `variantJson` data source
- `pileup` : requires a `bam` or `alignmentJson` data source
- `idiogram` : requires `idiogramJson` data source
- `location` : does not require a data source
- `scale` : does not require a data source

Multiple tracks can be added to a Pileup component by passing in a list of dicts, each of which corresponds to an individual track.

{{example pileupTrack}}

### Visualization Options
Depending on the visualization track, you can modify and set various visualization options. In this example, we set the option to view alignments as pairs by setting the value for `viewAsPairs` to `True`. Other vizOptions are as follows for each of the following track types:
- `coverage` and `features` : Set the track color by specifying a dict of RGB colors: `{ 'color': {'rgb': {'r': int, 'g': int, 'b': int, 'a': int}}}`
- `pileup` : Included vizOptions are `viewAsPairs: bool`, `colorByInsert: bool`, `colorByStrand: bool`,`hideAlignments: bool`
- `features` : Collapse overlapping features by specifying `{'collapse': True}`

{{example pileupViz}}

### Features
The `features` visualization allows you to view any features that have a genomic location (a contig, start, and stop). You can specify vizOptions for features, including the track color whether to collapse overlapping features.

{{example pileupFeatures}}

{{reference dash_bio.Pileup}}

## Example Data

- [NCBI SRA](https://www.ncbi.nlm.nih.gov/sra)
- [UCSC Sequence and Annotation Downloads](https://hgdownload.soe.ucsc.edu/downloads.html)
