---
url: /dash-bio/jsme
name: Jsme
description:
    "Molecule editor that supports drawing and editing
    of molecules and reactions."
thumbnail: jsme.png
languages:
  - python
---
# ![](/assets/images/language_icons/.svg) dash_bio.Jsme Examples and Reference

## Jsme

An example of a default Jsme component without any extra properties.

{{example defaultJsme}}

## Customization

### Property `smiles`
The molecule SMILE to display

{{example jsmeSmiles}}

### Property `style`
Generic style overrides on the plot div

{{example jsmeStyle}}

### Property `width` and `height`
The width and height of the JSME container. Can be set in px, % etc.

{{example jsmeWidthHeight}}

### Property `options`
String that is a comma separated string of JSME options.
The available options are described on the
[Wiki Jmol](https://wiki.jmol.org/index.php/Jmol_JavaScript_Object/JME/Options)

- `border`/`NOborder` - When in depict mode, displays a border around the molecule.
- `useOpenChemLib`/`NOuseOpenChemLib` - Use the OpenChemLib library for SMILES conversion, 2D coordinates computation and SVG export.
- `oldLook`/`newLook` - Style of the toolbar buttons and the interface.
- `keepHs`/`removeHs`/`removeHsC` - Remove hydrogens (all or just those bound to C) when reading a molecule with explicit hydrogens (e.g. from the PubChem database).
- `number`/`autonumber`/`star`/`noStar` - Possibility to mark atoms with a number or a circular highlight. All highlighted atoms will have an atom number equal to 1. The atom numbers will be included in the exported SMILES and MOL.
- `canonize`/`NOcanonize` - Keep or suppress SMILES canonicalization and detection of aromaticity.
- `stereo`/`NOstereo` - Keep or ignore stereochemistry when generating SMILES.
- `autoEZ`/`NOautoEZ` - Inclusion of E,Z stereochemistry when generating SMILES.
- `addNewPart`/`NOaddNewPart` - If multipart is enabled, when reading or pasting a new molecule, add it to the existing molecules or replace these.
- `paste`/`NOpaste` - Enable or not the paste action, including drop of a MOL/RXN; this can be used together with the depict option to have a read-only depiction.
- `reaction`/`NOreaction` - Enable or disable reaction input, and display or not the reaction button.
- `xButton`/`NOxButton` - Display or not the X button (left side, under the elements; to insert a nonstandard atom, e.g. any other element)
- `rButton`/`NOrButton` - Display or not the R button, to mark connection of substituent with the main scaffold (left side, under the elements)
- `query`/`NOquery` - Display or not the query button, which opens a dialog. In query mode, a SMARTS is generated when a SMILES is requested.
- `showDragAndDropSymbolInDepictMode`/`NOshowDragAndDropSymbolInDepictMode` - Display or not the drag and drop symbol (blue triangle at lower-right corner) in depict mode.
- `atomMoveButton`/`NOatomMoveButton` - Display or not the atom move button.
- `searchInChIkey`/`NOsearchInChIkey` - Display or hide the menu item for searching on the web using the current InChIKey.
- `exportSVG`/`NOexportSVG` - Display or hide the menu item for exporting SVG (useOpenChemLib must be set).
- `useOCLidCode`/`NOuseOCLidCode` - Display or hide the menu item for exporting OCL (useOpenChemLib must be set).
- `exportInChIauxInfo`/`NOexportInChIauxInfo` - Display or hide the menu item for exporting InChI AuxInfo.
- `exportInChIkey`/`NOexportInChIkey` - Display or hide the menu item for exporting InChIKey
- `exportInChI`/`NOexportInChI` - Display or hide the menu item for exporting InChI
- `hydrogens`/`NOhydrogens` - Display or hide hydrogens on heteroatoms.
- `depict`/`NOdepict` - Display only the canvas, without any toolbars for editing (useful for display of structure).
- `polarNitro`/`NOpolarNitro` - Convert or not nitro (and similar) groups into a nonpolar form.
- `zoom`/`NOzoom` - Allow zooming of the drawing area (mouse wheel).
- `toggle`/`NOtoggle` - Allow to switch automatically between editing and depict modes.
- `multiPart`/`NOmultiPart` - Allow to enter multipart structures (display the NEW button).
- `depictAction`/`NOdepictAction` - Allow structure editing in depict mode.

{{example jsmeOptions}}

## Example Data

- [PubChem - collection of freely accessible chemical information](https://pubchem.ncbi.nlm.nih.gov)
