---
url: /dash-bio/igv
name: Igv
description:
    "Dash Bio is a component library
    dedicated to visualizing bioinformatics data."
icon_path: images/icons_v2/www (1).svg
languages:
  - python
  - julia
  - matlab
thumbnail: 'igv.png'
---
# ![](/assets/images/language_icons/matlab_50px.svg) dash_bio.Igv Examples and Reference
see [Igv in action](https://dash.gallery/dash-igv/).

## Igv

An example of a default Igv component without any extra properties.

{{example defaultIgv}}

## Customization

### Genome
Select a genome using an identifier string (e.g. "hg19"). A list of pre-defined genomes hosted by IGV can be found [here](https://s3.amazonaws.com/igv.org.genomes/genomes.json).

{{example igvGnome}}

### Reference
Add a reference dictionary which can be used to specify the genomic data added to the IGV component, and add tracks to display features such as annotations, genome variants, alignments, and quantitative data.

For more information on reference options, visit the `IGV` wiki [here](https://github.com/igvteam/igv.js/wiki/Reference-Genome).

Multiple tracks can be added to a single reference by creating a list of dicts, each of which correspond to a single track. For more information on Track Types and Track Configurations, visit the `IGV` wiki [here](https://github.com/igvteam/igv.js/wiki/Tracks-2.0).

{{example igvReference}}

### Locus
The initial genomic location displayed on the viewer. This can be a string or a list of strings. In the example below, the locus is "chrV".

{{example igvLocus}}

### Minimum Bases
Minimum window size in base pairs when zooming in.

{{example igvMinimumBases}}

{{reference dash_bio.Igv}}

## Example Data

- [Assembly database at NCBI](https://www.ncbi.nlm.nih.gov/assembly/organism)
