terminate(pyenv);
clearvars;

df = readBioData('https://git.io/Ja6zV', 'dataframe',...
    {'sep', '\t', 'skiprows', int8(4)}).set_index('model');
data = df.values;

cols = py.list(df.columns.values);
rowLabels = py.list(df.index.values);

component = Dcc('Graph',{...
    'figure', dashBio(...
        'Clustergram',{...
            'data', data,...
            'row_labels', rowLabels,... 
            'column_labels', cols,...            
            'color_threshold', struct(...
                'row', 250,...
                'col', 700),...
            'height', 800,...
            'width', 600,...            
            'color_map', {...
                {0.0, '#636EFA'},...
                {0.25, '#AB63FA'},...
                {0.5, '#FFFFFF'},...
                {0.75, '#E763FA'},...
                {1.0, '#EF553B'}}})});  
    
components = {component};

% Run the app
startDash(components, 8057);