---
url: /layout
name: Part 1. Layout
description:
    "The Dash `layout` describes what your app will look like and is composed
    of a set of declarative Dash components."
icon: layout.svg
languages:
  - python
  - julia
  - r
  - fsharp
  - matlab
---

# ![](/assets/images/language_icons/matlab_50px.svg) Dash Layout

<blockquote>
This is the 1st chapter of the <dccLink children="Dash Fundamentals" href="/"/>.
The <dccLink href="/basic-callbacks" children="next chapter"/> covers Dash callbacks.
</blockquote>

This tutorial will walk you through a fundamental aspect of Dash apps, the
app `layout`, through five self-contained apps.

For production Dash apps, we recommend styling the app `layout` with
{{de Dash Enterprise <dccLink href="/dash-design-kit" children="Design Kit"/>.||oss Dash Enterprise [Design Kit](https://plotly.com/dash/design-kit/).}}

***

Dash apps are composed of two parts. The first part is the "`layout`", which describes what the app looks like.
The second part describes the interactivity of the app and will be
covered in the <dccLink href="/basic-callbacks" children="next chapter"/>.

Note: Throughout this documentation,

 MATLAB &reg;
code examples are meant to be saved as files and executed
in the command window.


{{oss
> If you're using Dash Enterprise's [Data Science Workspaces](https://plotly.com/dash/workspaces/),
> copy & paste the below code into your Workspace ([see video](https://plotly.com/dash/workspaces/#screencast)).

> _[Find out if your company is using Dash Enterprise](https://plotly.com/company-lookup/)_
}}

To get started, create a file named
`app.m`
, copy the code below into it, and then run it
 with `app`.

{{example getting_started_layout_1}}

```
>> app
Dash is running on http://127.0.0.1:8050/
```

Visit [http://127.0.0.1:8050/](http://127.0.0.1:8050/)
 in your web browser. You should see an app that looks like the one above.

Note:

1. The `layout` is composed of a tree of "components" such as
   `Html('Div')`
    and `axes`. The layout components are the first argument of `startDash`.
2. The `Html`
   function
    has a component for every HTML tag.
   The `Html('H1', {'children', 'Hello Dash'}) `
    component generates a `<h1>Hello Dash</h1>` HTML element in your app.
3. Not all components are pure HTML.
   `Dcc`
   describe higher-level components that are interactive and are generated with
    JavaScript, HTML, and CSS through the React.js library.

4. Each component is described entirely through the parameters to its function.
    Dash is _declarative_: you will primarily describe your app
    through these attributes.
5. The `children` property is special. By convention, it's always the first attribute {{python
which means that you can omit it: `html.H1(children='Hello Dash')` is the same as `html.H1('Hello Dash')`which means that you can omit it: `Html('H1', {'children', 'Hello Dash'})`
   is the same as `Html('H1', {'Hello Dash'})`. It  can contain a string, a number, a single component, or a list of components.
||r 5. For pure HTML components, any named argument becomes an attribute on the HTML tag, while any unnamed argument becomes a child. For example, `div(id = "name", "Joe")` results in `<div id="name">Joe</div>`.}}
6. The fonts in your app will look a little bit different than what is displayed here.
   This app is using a custom CSS stylesheet and {{de Dash Enterprise <dccLink href="/dash-design-kit" children="Design Kit"/>||oss Dash Enterprise [Design Kit](https://plotly.com/dash/design-kit/)}}
    to modify the default styles of the elements. You can learn more about custom CSS in the
    <dccLink href="/external-resources" children="CSS tutorial"/>.




### Making Your First Change



You can change the title "Hello Dash" in your app or change the
`x` or `y` data. Save the file and restart the app to see your changes.


{{oss {{dash-club}} }}
### More about HTML Components

`Html`
contains a component class for every HTML tag as well as keyword arguments for all of the HTML arguments.



Let's customize the text in our app by modifying the inline styles of the components.
 Create a file named `app.m` with the following code:

{{example getting_started_layout_2}}

In this example, we modified the inline styles of the
 `Html('Div')`
and `Html('H1')` style` property}}.

```matlab
Html('H1', {'children', 'Hello Dash',...
    'style', struct(...
        'textAlign', 'center',...
        'color', '#7FDBFF')});
```


The above code is rendered in the Dash app as
`<h1 style="text-align: center; color: #7FDBFF">Hello Dash</h1>`.

There are a few important differences between the `Html`
and the HTML attributes:

1. The `style` property in HTML is a semicolon-separated string. In Dash,
   you can just supply a struct.
2. The keys in the `style` struct are [camelCased](https://en.wikipedia.org/wiki/Camel_case).
   So, instead of `text-align`, it's `textAlign`.
3. The HTML `class` attribute is `className` in Dash.
4. The children of the HTML tag is specified through the `children` keyword
   argument. By convention, this is always the _first_ argument {{python|julia|matlab and so it is often omitted.
||r 4. The HTML `for` attribute is `htmlFor` in Dash.
}}


Besides that, all of the available HTML attributes and tags are available
to you within your MATLAB &reg; context.



***

### Reusable Components

By writing our markup in MATLAB &reg;, we can create complex reusable components like tables without switching contexts or languages.

Here's a quick example that generates a `Table` from a
 table using `readtable`. Create a file named `app.m` with the following code:

{{example getting_started_table}}



### More about Visualization

The `Dcc`
 library includes a component called
 `Graph `.

`Graph`
 renders interactive data visualizations using the open source
[plotly.js](https://github.com/plotly/plotly.js) JavaScript graphing
library. Plotly.js supports over 35 chart types and renders charts in
both vector-quality SVG and high-performance WebGL.

The `figure` argument in the `Graph`
 component is the same `figure` argument that is used by `plotly.py`, Plotly's
open source  graphing library.
Check out the [plotly.py documentation and gallery](https://plotly.com/python)
to learn more.

Here's an example that creates a scatter plot from a
 table using `readtable`. Create a file named `app.m` with the following code:

{{example getting_started_viz}}

*These graphs are interactive and responsive.
 **Hover** over points to see their values,
 **click** on legend items to toggle traces,
 **click and drag** to zoom,
 **hold down shift, and click and drag** to pan.*


### Markdown

While Dash exposes HTML through `Html` , it can be tedious to write your copy in HTML.  For writing blocks of text, you can use the
`Markdown` component in
`Dcc`. Create a file named `app.m` with the following code:

{{example getting_started_markdown}}

### Core Components

`Dcc`
 includes a set of higher-level components like dropdowns, graphs, markdown blocks, and more.

Like all Dash components, they are described entirely declaratively.
Every option that is configurable is available as a keyword argument
of the component.

We'll see many of these components throughout the tutorial.
You can view all of the available components in the
<dccLink href="/dash-core-components" children="Dash Core Components overview"/>.

Here are a few of the available components.
Create a file named `app.m` with the following code:

{{example getting_started_core_components}}

### Help

Dash components are declarative: every configurable aspect of these
components is set during instantiation as a keyword argument.

Call `help` in your MATLAB &reg; command window on any of the components to
learn more about a component and its available arguments.

```matlab
  help uidropdown

  uidropdown Create drop-down component
  | dropdown = uidropdown creates a drop down in a new UI figure window.

  | dropdown = uidropdown(parent) specifies the object in which to create
  | the drop down.

  | dropdown = uidropdown( ___ ,Name,Value) specifies drop down properties
  | using one or more Name,Value pair arguments. Use this option with any
  | of the input argument combinations in the previous syntaxes. Use the
  | Name,Value pair, Editable,'on' to specify a drop down that allows users
  | to type text into the drop down or select a predefined option.

  | Example 1: Create a Drop Down
  |  dropdown = uidropdown;

  | Example 2: Create an Editable Drop Down
  |  dropdown = uidropdown('Editable','on');

  | Example 3: Specify the Parent Object for a Drop Down
  |  % Specify a small UI figure as the parent object for a drop down.
  |  fig = uifigure('Position', [100 100 300 250]);
  |  dropdown = uidropdown(fig);
```

### Summary

The `layout` of a Dash app describes what the app looks like.
The `layout` is a hierarchical tree of components, or a list of components (in Dash 2.17 and later).

`Html`
 library
 provides classes for all of the HTML
tags and the keyword arguments describe the HTML attributes like `style`, `class`, and `id`.
The `Dcc`
 library
 generates higher-level components like controls and graphs.
}}

For reference, see:

* <dccLink href="/dash-core-components" children="Dash Core Components overview"/>
* <dccLink href="/dash-html-components" children="Dash HTML Components overview"/>

The next part of the Dash Fundamentals covers how to make these apps interactive.
<dccLink href="/basic-callbacks" children="Dash Fundamentals Part 2: Basic Callbacks"/>
