---
url: /vtk/other
name: Other Dash VTK Components
description: "Dash VTK Components that are not used for building representations."
languages:
    - python
    - julia
---

# ![](/assets/images/language_icons/matlab_50px.svg) Other Dash VTK Components

## Mesh

This element is a helper on top of  which has a helper function that goes with it which will help you map a __vtkDataSet__ into a single property of the  element.



Note that we assume that `state.field` exists when we use  in the snippet above. However, `state.field` is optional, so when it's not available the `children` is not created, and  would not be needed.

The  element expects a single __state__ property that is internally split into 2 elements to represent the geometry and the field that you want to optionally attach to your mesh. The structure could be defined as follows:

- __state__
  - mesh: (Contains the properties of )
    - points = []
    - verts = []
    - lines = []
    - polys = []
    - strips = []
    - connectivity = 'manual' # [manual, points, triangles, strips]
  - field: (Contains the properties of )
    - location: "PointData" / "CellData"
    - name: Name of the field (optional)
    - values: Array of values for the field
    - numberOfComponents: Number of components per point/cell
    - type: Name of TypedArray to use (Uint8Array, Int8Array, Float32Array, Float64Array...)

## Volume

This element is a helper on top of  which has a Python helper function that goes with it which will help you map a __vtkImageData__ into a single property of the  element.



The  element expects a single __state__ property that is internally split into 2 elements to represent the geometry and the field that you want to optionally attach to your mesh. The structure could be defined as follows:

- __state__
  - image: (Contains the properties of __ImageData__)
    - dimensions
    - spacing
    - origin
  - field: (Contains the properties of __DataArray__)
    - values: Array of values for the field
    - numberOfComponents: Number of components per point/cell
    - type: Name of TypedArray to use (Uint8Array, Int8Array, Float32Array, Float64Array...)

## Algorithm

This element allows you to create and configure a vtk.js class. This element expect only 2 properties:
- __vtkClass__: The name of the vtkClass to instantiate.
- __state__: The set of properties to apply on the given vtkClass.

The current [list of classes](https://github.com/Kitware/react-vtk-js/blob/master/src/AvailableClasses.js#L4-L15) available to instantiate are:

- __vtkClass__:
  - [vtkConcentricCylinderSource](https://kitware.github.io/vtk-js/api/Filters_Sources_ConcentricCylinderSource.html)
  - [vtkConeSource](https://kitware.github.io/vtk-js/api/Filters_Sources_ConeSource.html)
  - [vtkCubeSource](https://kitware.github.io/vtk-js/api/Filters_Sources_CubeSource.html)
  - [vtkCylinderSource](https://kitware.github.io/vtk-js/api/Filters_Sources_CylinderSource.html)
  - [vtkLineSource](https://kitware.github.io/vtk-js/api/Filters_Sources_LineSource.html)
  - [vtkPlaneSource](https://kitware.github.io/vtk-js/api/Filters_Sources_PlaneSource.html)
  - [vtkPointSource](https://kitware.github.io/vtk-js/api/Filters_Sources_PointSource.html)
  - [vtkSphereSource](https://kitware.github.io/vtk-js/api/Filters_Sources_SphereSource.html)
  - [vtkWarpScalar](https://kitware.github.io/vtk-js/api/Filters_General_WarpScalar.html)
- __state__: See the references above for the properties available for each vtkClass.

The following example uses a vtk source in vtk.js to generate a mesh

{{example t04_algorithm}}
![t04](/assets/images/vtk/t04_algorithm.jpg)

## Reader

This element is similar to the  except that it focuses on vtk.js readers by allowing you to leverage their custom API.
Like , a reader expects a __vtkClass__ among those [listed below](https://github.com/Kitware/react-vtk-js/blob/master/src/AvailableClasses.js#L17-L24):

- __vtkClass__
  - vtkPLYReader
  - vtkSTLReader
  - vtkElevationReader
  - vtkOBJReader
  - vtkPDBReader
  - vtkXMLImageDataReader
  - vtkXMLPolyDataReader

Then use one of the properties below to feed the reader some data:
- __url__: set of url to fetch data from (on the JS side)
- __parseAsText__: set the text content to process
- __parseAsArrayBuffer__: set binary data to process from base64 string

Since the data loading is going to be asynchronous, we've enabled some automatic callbacks to either trigger a _render_ or a _resetCamera_ once the data became available. To enable these callbacks, set the following properties to your liking:
- __renderOnUpdate__:  (default)
- __resetCameraOnUpdate__:  (default)

{{example t05_reader}}
![t05](/assets/images/vtk/t05_reader.jpg)

## ShareDataSet

This element does not affect the dataset, but it allows the JavaScript side to reuse an existing __vtkDataSet__ for another __Representation__ or __filter__.

The only property expected in a  is a name to properly reference it elsewhere. A __name__ is provided dy default, so in the case of only one _dataset_, you would not need to specify this property.

The following example shows how to create a view with one  and four representations of it.

{{example t06_shared_dataset View full code}}
![t06](/assets/images/vtk/t06_shared_dataset.jpg)
