terminate(pyenv);
clearvars;

% Read data file
data = readtable('https://git.io/Jgvhr');

data = data((1:8),:); % Select first 8 rows

% Create ui elements
uiFigure = uifigure('visible', 'off');
size = [12, 12];
uiGrid = uigridlayout(uiFigure, size);

dataTable = uitable(uiGrid, 'ColumnName', data.Properties.VariableNames,...
    'Data', data, 'visible', 'off', 'Tag', 'table');

lnrows = height(dataTable.Data);
lncols = width(dataTable.Data);
tooltip_data = {lnrows};

for i=1:lnrows
    d = struct();

    for j=1:lncols
        fld = string(dataTable.ColumnName(j));
        d.(fld) = struct(...
            'value', string(dataTable.Data{i,j}), 'type', 'markdown');
    end
    
    tooltip_data{i} = d;
end

tooltip_data = {tooltip_data};

css = {1};
css{1} = struct(...
    'selector','.dash-table-tooltip',...
    'rule','background-color: gray; font-family: monospace;');
css = {css};

dataTable.UserData = struct(...
    'tooltip_data', tooltip_data,...
    'css', css,...
    'tooltip_delay', 10,... % In ms. If set to 0 tooltip is not shown...
    'tooltip_duration', -1); % Use -1 to prevent the tooltip from disappearing

% Run the app
startDash(uiGrid, 8057);