terminate(pyenv);
clearvars;

% Read data file
data = readtable('https://git.io/Jgvhr');

data = data((1:3),:); % Select first 3 rows

% Create ui elements
uiFigure = uifigure('visible', 'off');
size = [12, 12];
uiGrid = uigridlayout(uiFigure, size);

dataTable = uitable(uiGrid, 'ColumnName', data.Properties.VariableNames,...
    'Data', data, 'visible', 'off', 'Tag', 'table');

tooltip_header = struct();
tooltip_header.('DRG') = 'Diagnosis Related Group';
tooltip_header.('ProviderCity') = 'Provider City Name';
tooltip_header.('ProviderId') = 'Provider Identification (number)';

style_header_conditional = {3};
style_header_conditional{1} = struct(...
    'if',struct('column_id','DRG'),...
    'textDecoration','underline',...
    'textDecorationStyle','dotted');
style_header_conditional{2} = struct(...
    'if',struct('column_id','ProviderCity'),...
    'textDecoration','underline',...
    'textDecorationStyle','dotted');
style_header_conditional{3} = struct(...
    'if',struct('column_id','ProviderId'),...
    'textDecoration','underline',...
    'textDecorationStyle','dotted');
style_header_conditional = {style_header_conditional};

dataTable.UserData = struct(...
    'tooltip_header', tooltip_header,...
    'style_header_conditional', style_header_conditional,...
    'style_cell', struct(...
        'overflow','hidden',...
        'textOverflow','ellipsis',...
        'maxWidth',0),...
    'tooltip_delay', 10,... % In ms. If set to 0 tooltip is not shown...
    'tooltip_duration', -1); % Use -1 to prevent the tooltip from disappearing

% Run the app
startDash(uiGrid, 8057);