terminate(pyenv);
clearvars;

% Define data table
Date = {'2015-01-01';'2015-10-24';'2016-05-10';'2017-01-10';'2018-05-10';'2018-08-15'};
Delivery = {'2015-01-02';'2015-10-24';'2016-05-15';'2017-01-14';'2018-05-10';'2018-08-11'};
Region = {'Montreal';'Toronto';'New York City';'Miami';'San Francisco';'London'};
Temperature = [1;-20;3.512;4;10423;-441.2];
Humidity = [10;20;30;40;50;60];
Pressure = [2;10924;3912;-10;3591.2;15];

data = table(Date, Delivery, Region, Temperature, Humidity, Pressure);
data.id = (0:height(data)-1).'; % Add index column, starting from 0

% Create ui elements
uiFigure = uifigure('visible', 'off');
size = [12, 12];
uiGrid = uigridlayout(uiFigure, size);

dataTable = uitable(uiGrid, 'ColumnName', data.Properties.VariableNames,...
    'Data', data, 'visible', 'off', 'Tag', 'table');

lncols = height(dataTable);
columns = {lncols};
columns{1} = struct('name', 'Date', 'id', 'Date', 'type', 'datetime', 'editable', false);
columns{2} = struct('name', 'Delivery', 'id', 'Delivery', 'type', 'datetime');
columns{3} = struct('name', 'Region', 'id', 'Region', 'type', 'text');
columns{4} = struct('name', 'Temperature', 'id', 'Temperature', 'type', 'numeric');
columns{5} = struct('name', 'Humidity', 'id', 'Humidity', 'type', 'numeric');
columns{6} = struct('name', 'Pressure', 'id', 'Pressure', 'type', 'any');
columns = {columns};

style_data_conditional = {9};
style_data_conditional{1} = struct(...
    'if', struct('column_id', 'Region'),...
    'backgroundColor', 'dodgerblue',...
    'color', 'white');
style_data_conditional{2} = struct(...
    'if', struct('filter_query', '{Humidity} > 19 && {Humidity} < 41',...
        'column_id', 'Humidity'),...
    'backgroundColor', 'tomato',...
    'color', 'white');
style_data_conditional{3} = struct(...
    'if', struct('column_id', 'Pressure',...
        'filter_query', sprintf('{Pressure} = %d', max(data.Pressure))),...
    'backgroundColor', '#85144b',...
    'color', 'white');
style_data_conditional{4} = struct(...
    'if', struct('row_index', 5, 'column_id', 'Region'),...
    'backgroundColor', 'hotpink',...
    'color', 'white');
style_data_conditional{5} = struct(...
    'if', struct('filter_query', '{id} = 4', 'column_id', 'Region'),...
    'backgroundColor', 'RebeccaPurple');
style_data_conditional{6} = struct(...
    'if', struct('filter_query', '{Delivery} > {Date}', 'column_id', 'Delivery'),...
    'backgroundColor', '#3D9970');
style_data_conditional{7} = struct(...
    'if', struct('column_editable', false),...
    'backgroundColor', 'rgb(240, 240, 240)',...
    'cursor', 'not_allowed');
style_data_conditional{8} = struct(...
    'if', struct('column_type', 'text'),...
    'textAlign', 'left');
style_data_conditional{9} = struct(...
    'if', struct('state', 'active'),...
    'backgroundColor', 'rgba(0, 116, 217, 0.3)',...
    'border', '1px solid rgb(0, 116, 217)');

style_data_conditional = {style_data_conditional};

dataTable.UserData = struct(...
    'sort_action', 'native',...
    'columns', columns,...
    'editable', true,...
    'style_data_conditional', style_data_conditional);

% Run the app
startDash(uiGrid, 8057);