%%%%%%%%%%%
%% app.m %%
%%%%%%%%%%%

terminate(pyenv);
clearvars;

% Read data file
data = readtable('https://git.io/JgqCd', 'PreserveVariableNames', true);

data = data(:, sort(data.Properties.VariableNames));

PAGE_SIZE = 5;

% Create ui elements
uiFigure = uifigure('visible', 'off');
size = [12, 12];
uiGrid = uigridlayout(uiFigure, size);

dataTable = uitable(uiGrid, 'ColumnName', data.Properties.VariableNames,...
    'Data', data, 'visible', 'off', 'Tag', 'table-multicol-sorting');

dataTable.UserData = struct(...
    'page_current', 0,...
    'page_size', PAGE_SIZE,...
    'page_action', 'custom',...
    'sort_action', 'custom',...
    'sort_mode', 'multi',...
    'sort_by', {{}});

% Callbacks
args = {...
    argsOut('table-multicol-sorting','data'),...
    argsIn('table-multicol-sorting','page_current'),...
    argsIn('table-multicol-sorting','page_size'),...
    argsIn('table-multicol-sorting','sort_by')};
handle = 'update_table';
callbackDat = {args, handle};

% Run the app
startDash(uiGrid, 8057, callbackDat);

%%%%%%%%%%%%%%%%%%%%
%% update_table.m %%
%%%%%%%%%%%%%%%%%%%%

function df = update_table(page_current, page_size, sort_by)
    data1 = readtable('https://git.io/JgqCd', 'PreserveVariableNames', true);
    data2 = data1(:, sort(data1.Properties.VariableNames));
    
    s = size(sort_by);
    
    if s
        direction = {s(2)};
        cols = {s(2)};
        for i=1:s(2)
            cols{i} = sort_by{i}.column_id;
            if strcmp(sort_by{i}.direction, 'asc')
                direction{i} = 'ascend';                
            else
                direction{i} = 'descend';
            end
        end
        df = sortrows(data2, cols, direction);
    else
        df = data2;
    end   

    df = df(page_current*page_size+1:(page_current+1)*page_size,:);
    df = char(jsonencode({df}));

end