---
url: /cytoscape
name: Overview
breadcrumb: Dash Cytoscape
description:
    "Dash Cytoscape is our network visualization component. It offers a declarative
    and pythonic interface to create beautiful, customizable, interactive and reactive
    network graphs."
icon: settings.svg
languages:
    - python
    - julia
---

# ![](/assets/images/language_icons/matlab_50px.svg) Dash Cytoscape

{{oss
<iframe
    width="160px"
    height="30px"
    style="border: none"
    src='https://ghbtns.com/github-btn.html?user=plotly&repo=dash-cytoscape&type=star&count=true&size=large'>
</iframe>
}}

> Dash Cytoscape is a graph visualization component for creating easily
> customizable, high-performance, interactive, and web-based networks. It
> extends and renders [Cytoscape.js](http://js.cytoscape.org), and
> offers deep integration with Dash layouts and callbacks, enabling the
> creation of powerful networks in conjunction with the rich collection of Dash components



## Quickstart

```
||julia
```julia
julia>using Pkg
julia>Pkg.add("DashCytoscape")
```
}}

{{example simple}}


> Dash Cytoscape graphs are interactive! Scroll to zoom and drag on
> the canvas to move the entire graph around. You can move nodes by
> *dragging* it, or by *clicking, holding, and moving your mouse*
> to the desired location (and click again to release).
>
> This also work in mobile! Tap-and-hold on a node to move it, or on
> the canvas to move the entire graph. Pinch your fingers outwards to
> zoom in, or pinch them together to zoom out.


## Dash Cytoscape User Guide

<dccLink href="/cytoscape/reference" children="Reference"/>

A comprehensive list of all of the Cytoscape properties.

<dccLink href="/cytoscape/elements" children="Basic Usage & Elements"/>

Overview of element declaration and manipulation.

<dccLink href="/cytoscape/layout" children="Layouts"/>

Description of built-in layouts, and how to modify their properties. These include:

- Display Methods
- Fine-tuning the Layouts
- Physics-based Layouts
- Loading External Layout

<dccLink href="/cytoscape/styling" children="Styling"/>

Methods to style elements with a CSS-like syntax. These include:

- The `stylesheet` parameter
- Basic selectors and styles
- Comparing data items using selectors
- Styling edges
- Displaying Images

<dccLink href="/cytoscape/callbacks" children="Callbacks"/>

Methods to combine Dash callbacks to update your Cytoscape object. These include:

- Changing Layouts
- Interactively update styles
- Adding and removing elements

<dccLink href="/cytoscape/events" children="Events and User Interactions"/>

Overview of user-interaction events that trigger callbacks in Dash, and how to use them to update the Cytoscape component.

- Simple callback construction
- Click, tap and hover
- Selecting multiple elements
- Advanced usage of callbacks

<dccLink href="/cytoscape/biopython" children="Biopython Examples"/>

Examples of applications in bioinformatics using Biopython. These include:

- Parsing the Phylo object
- Defining layout and stylesheet
- Layout and Callbacks

<dccLink href="/cytoscape/images" children="Exporting Images"/>

This example shows how to export your Cytoscape graphs as images (jpg, png, svg).

<dccLink href="/cytoscape/responsive" children="Making responsive graphs"/>

This example shows how to build a responsive Cytoscape graph.
