---
url: /dash-core-components/tooltip
name: Tooltip
description:
    "dcc.Tooltip is a component that precisely places tooltips on figures, designed for dcc.Graph and compatible with other graph and diagram components."
languages:
    - python
---

# ![](/assets/images/language_icons/matlab_50px.svg) dcc.Tooltip

**New in Dash 2.0**

`dcc.Tooltip` gives you a tooltip pointing to a precise pixel
location on the page. It was designed primarily for greater flexibility over
the hover information built into `dcc.Graph` figures, but it can
be used with any component that draws diagrams or graphs on the page.

## Examples

Find a few usage examples below.

### Using URLs to Load Images and Text in Tooltips

Here's an example of creating a tooltip with images and text in them, loaded
by their URLs:

{{example tooltip_basic_2}}

### Visualizing t-SNE Plot of MNIST Images

The following example visualizes the t-SNE results of handwritten digit images from the MNIST dataset,
with the images shown in the tooltips when hovered:

{{example tooltip_mnist_tsne}}

### Using base64 Encoded Images

This example uses python `PIL` library to encode an image into base64 format and then
returns it from a callback:

{{example tooltip_base64}}

### Loading Text

The loading text of the tooltip can be set using `loading_text`, which is set "Loading..."
by default. Here's an example that uses the `loading_text` parameter along with a frontend
callback.

{{example tooltip_loading}}

### Styling Tooltip with Background and Border Color

The tooltips can be styled using the `background_color` and `border_color` parameters:

{{example tooltip_styling}}

------------------------

{{reference dcc.Tooltip}}
