---
url: /dash-bio/nglmoleculeviewer
name: NglMoleculeViewer
description:
    "Dash Bio is a component library
    dedicated to visualizing bioinformatics data."
icon_path: images/icons_v2/www (1).svg
languages:
  - python
  - julia
thumbnail: 'nglmoleculeviewer.png'
---
# ![](/assets/images/language_icons/matlab_50px.svg) dash_bio.NglMoleculeViewer Examples and Reference
see [NglMoleculeViewer in action](https://dash-gallery.plotly.host/dash-ngl-molecule-viewer).

## NglMoleculeViewer

An example of a default NglMoleculeViewer component without any extra properties.

{{example defaultNglMolecule}}

## Customization

### Molecule Styles
Molecule styles and representations can be styled with the `molStyles` property which accepts a `dict` of arguments. Molecule representations can be combined and stacked together by setting a `list` of representations. The following representations are available:
- Molecules Styles: `backbone`, `ball+stick`, `cartoon`, `hyperball`, `licorice`, `line`, `ribbon`, `rope`, `spacefill`, `surface`, `trace`, `tube`
- Additional Representations: `axes`, `axes+box`, `helixorient`, `unitcell`

With the `sideByside` key, we can choose whether multiple molecules should be represented side-by-side or intertwined. Note that in `sideByside` mode, the molecules cannot be independently rotated or panned.

{{example nglStyles}}

### Multiple Molecules
Multiple molecules can be visualized by adding entries to the data list. In the example below, we use multiple dropdown selections to add molecules to the stage. Each molecule can have its own set of atoms and residues highlighted. Individual molecules can be interacted with by holding down the `CTRL` key. If adding or removing molecules from the stage, make sure the `resetView` prop is set to false.

{{example nglMultiple}}

### Height and Width
The Height and Width (in px or as a number) of the container in which the molecules will be displayed.

{{example nglHW}}

### Stage
Similar to the molecular styles, the stage parameters can also be set. The background color, quality of the render, and the camera perspective are part of the `stageParameters` prop, and can be passed as keys of a `dict`.

{{example nglStage}}

### Saving an Image
An image with the selected parameters can be saved as a `.PNG` by flagging the `downloadImage` property. With the `imageParameters` optional dict, we can specify whether to enable `antialias`, `transparency`, or `trim`, and set the `filename` for the saved image.

{{example nglSavImg}}

### Selecting Molecule Chains and Atoms
The molecule data must be entered in a specific format to define how many molecules should be shown and/or which chains on those molecules are shown. Specific ranges of amino acids and atoms on the molecule can be highlighted as well. To see which filtering options are available to use with a particular molecule, it may be helpful to view the PDB file entries for a range of atoms which specify the atom names, the residues they belong to, and a one-letter code for the chain.



The `dash_bio.utils.ngl_parser` helper function can help simplify this process by generating the appropriate data format based on the string provided in the above format as the `pdb_id` argument. It will return a dictionary with the contents of the PDB file, selected residues and ranges, and atoms highlighted in the color selected. Specify whether the data path is locally or remotely hosted with the `local` boolean argument.

The color and radius of chosen atoms can be set through the `molStyles` property with the "chosenAtomsColor" and "chosenAtomsRadius" keys.

{{example nglChainsAtoms}}

{{reference dash_bio.NglMoleculeViewer}}

## Example Data

- https://github.com/plotly/datasets/tree/master/Dash_Bio/Molecular
- [RCSB Protein Data Bank](https://www.rcsb.org/)
- [Computational predictions of protein structures associated with COVID-19](https://deepmind.com/research/open-source/computational-predictions-of-protein-structures-associated-with-COVID-19)
