%%%%%%%%%
% app.m %
%%%%%%%%%

terminate(pyenv);
clearvars;

% Read data files
modelData = readBioData('https://git.io/JV8hc', 'noutf8');
stylesData  = readBioData('https://git.io/JV4er', 'noutf8');

componentMolecule = dashBio('Molecule3dViewer', {...
        'id', 'dashbio-default-molecule3d',...
        'styles', stylesData,...
        'modelData', modelData});
    
Hr = Html('Hr');

divHtml = Html('Div', {'id', 'default-molecule3d-output',...
    'style', struct('whiteSpace','pre-line')});
    
components = {componentMolecule, Hr, divHtml};

% Callbacks
args = {...
    argsOut('default-molecule3d-output', 'children'),...
    argsIn('dashbio-default-molecule3d', 'selectedAtomIds')};
handle = 'show_selected_atoms';
callbackDat = {args, handle};

% Run the app
startDash(components, 8057, callbackDat);

%%%%%%%%%%%%%%%%%%%%%%%
% show_selected_atoms %
%%%%%%%%%%%%%%%%%%%%%%%

function out = show_selected_atoms(atom_ids)
    if isempty(atom_ids) || any(strcmp(atom_ids, "NaN"))
        out = jsonencode({sprintf(...
            'No atom has been selected. Click somewhere on the molecular structure to select an atom.')});
    else
        modelData = readBioData('https://git.io/JV8hc', 'noutf8');
        out = '';
        
        for i=1:numel(atom_ids)
            atm = atom_ids{i};
            out = sprintf(strcat(out,...
                sprintf('\n\nElement: %s', string(modelData{'atoms'}{atm}{'element'})),...
                sprintf('\nChain: %s', string(modelData{'atoms'}{atm}{'chain'})),...
                sprintf('\nResidue name: %s', string(modelData{'atoms'}{atm}{'residue_name'}))));
        end
        
        out = jsonencode({out});
    end
end