terminate(pyenv);
clearvars;

component = dashBio('Igv', {...
        'id', 'reference-igv',...
        'reference', struct(...
            'id', 'ASM985889v3',...
            'name', 'Sars-CoV-2 (ASM985889v3)',...
            'fastaURL', 'https://s3.amazonaws.com/igv.org.genomes/covid_ASM985889v3/GCF_009858895.2_ASM985889v3_genomic.fna',...
            'indexURL', 'https://s3.amazonaws.com/igv.org.genomes/covid_ASM985889v3/GCF_009858895.2_ASM985889v3_genomic.fna.fai',...
            'order', 1000000,...
            'tracks', {struct(...
                'name', 'Annotations',...
                'url', 'https://s3.amazonaws.com/igv.org.genomes/covid_ASM985889v3/GCF_009858895.2_ASM985889v3_genomic.gff.gz',...
                'displayMode', 'EXPANDED',...
                'nameField', 'gene',...
                'height', 150,...
                'color', 'rgb(176,141,87)')})});  
    
components = {component};

% Run the app
startDash(components, 8057);