terminate(pyenv);
clearvars;

df = readBioData('https://git.io/Ja6zV', 'dataframe',...
    {'sep', '\t', 'skiprows', int8(4)}).set_index('model');
data = df.values;

cols = py.list(df.columns.values);
rowLabels = py.list(df.index.values);

component = Dcc('Graph',{...
    'figure', dashBio(...
        'Clustergram',{...
            'data', data,...
            'row_labels', rowLabels,... 
            'column_labels', cols,...            
            'color_threshold', struct(...
                'row', 250,...
                'col', 700),...
            'height', 800,...
            'width', 700,...            
            'color_list', struct(...
                'row', {{'#636EFA', '#00CC96', '#19D3F3'}},...
                'col', {{'#AB63FA', '#EF553B'}},...
                'bg', '#506784'),...
            'line_width', 2})});  
    
components = {component};

% Run the app
startDash(components, 8057);