---
url: /annotations
name: Overview & Reference
breadcrumb: Image Annotations
description: "Image Annotations for image processing applications."
icon: gallery.svg
languages:
    - python
---
# ![](/assets/images/language_icons/matlab_50px.svg) Image Annotations with Dash
This tutorial shows how to annotate images with different drawing tools in plotly figures, and how to use such annotations in Dash apps.

## Annotation Tools in Plotly Figures

With the plotly graphing library, [it is possible to draw annotations on Cartesian axes](https://plotly.com/python/shapes/#drawing-shapes-on-cartesian-plots), which are recorded as shape elements of the figure layout.

In order to use the drawing tools of a plotly figure, one must set its dragmode to one of the available drawing tools. This can be done programmatically, by setting the `dragmode` attribute of the figure `layout`, or by selecting a drawing tool in the modebar of the figure. Since buttons corresponding to drawing tools are not included in the default modebar, one must specify the buttons to add in the `config` prop of the `dcc.Graph` containing the plotly figure.

In the figure below, you can try to draw a rectangle by left-clicking and dragging, then you can try the other drawing buttons of the modebar.

{{example annotations101}}

## Dash Callback Triggered When Drawing Annotations

When using a plotly figure in a `dcc.Graph` component in a Dash app, drawing a shape on the figure will modify the `relayoutData` property of the `dcc.Graph`. You can therefore define a callback listening to `relayoutData`. In the example below we display the content of `relayoutData` inside an `html.Pre`, so that we can inspect the structure of `relayoutData` (when developing your app, you can also just print the variable inside the callback to inspect it).

{{example annotations_callback}}

In the example below, we add all the available drawing tools to the modebar, so that you can inspect the characteristics of drawn shapes for the different types of shapes: rectangles, circles, lines, closed and open paths.

Rectangles, circles or ellipses and lines are all defined by their bounding-box rectangle, that is by the coordinates of the start and end corners of the rectangle, `x0`, `y0`, `x1` and `y1`.

As for paths, open and closed, their geometry is defined as an [SVG path](https://en.wikipedia.org/wiki/Scalable_Vector_Graphics).

{{example drawing_tools}}

## Changing The Style of Annotations

The style of annotations can be changed thanks to interactive components such as sliders, dropdowns, or color pickers. Their values can be used in a callback to define the `newshape` attribute of the figure layout, as in the following example.

{{example annotation_style}}

## Extracting an Image Subregion Defined By an Annotation

Rather than the geometry of annotations, one is often interested in extracting the region of interest of the image delineated by the shape. The two examples show how to do this first for rectangles, and then for a closed path. In these two examples, the histogram of the region delineated by the latest shape is displayed.

{{example region_extraction}}

For a path, we need the following steps
- we retrieve the coordinates of the vertices of the path from the SVG path

  
{{example path_extraction}}

## Modifying Shapes and Parsing `relayoutData`

When adding a new shape, the `relayoutData` variable consists in the list of all layout shapes. It is also possible to delete a shape by selecting an existing shape, and by clicking the "delete shape" button in the modebar.

Also, existing shapes can be modified if their `editable` property is set to `True`. In the example below, you can
- draw a shape
- then click on the shape perimeter to select the shape
- drag one of its vertices to modify the shape

Observe that when modifying the shape, only the modified geometrical parameters are found in the `relayoutData`.

{{example modify_shapes}}

The example below extends on the previous one where the histogram of a ROI is displayed. Here, we tackle both the case where a new shape is drawn, and where an existing shape is modified.

{{example modify_shapes_part2}}