%----------------------------%
%      callback-chain.m      %
%----------------------------%

terminate(pyenv);
clearvars; % Removes all variables from the currently active workspace.

cities = struct(...
    'America', {{'New York City', 'San Francisco', 'Cincinnati'}},...
    'Canada', {{'Montréal', 'Toronto', 'Ottawa'}});

countries = fieldnames(cities);

% Create ui grid.
uifig = uifigure('visible', 'on');
size = [12, 12];
uigrid = uigridlayout(uifig, size);

buttonGroupCountries = uibuttongroup(uigrid, 'Tag', 'countries-radio');   
radioButtonCountry1 = uiradiobutton(buttonGroupCountries, 'Text', string(countries{1}));
radioButtonCountry2 = uiradiobutton(buttonGroupCountries, 'Text', string(countries{2}));
buttonGroupCountries.Layout.Row = [1 2];
buttonGroupCountries.Layout.Column= [1 2];
buttonGroupCountries.Children(2).Position=[10 30 91 22];

buttonGroupCities = uibuttongroup(uigrid, 'Tag', 'cities-radio');  
buttonGroupCities.Layout.Row = [3 5];
buttonGroupCities.Layout.Column= [1 2];

textInfo = uitextarea(uigrid, 'Tag', 'display-selected-values');
textInfo.Layout.Row = 6;
textInfo.Layout.Column= [1 2];

% Define callbacks.

% First callback: updates available options based on selected country
argsSetCitiesOptions = {argsOut('cities-radio', 'options'), ...
    argsIn('countries-radio', 'value') };
handleSetCitiesOptions = 'set_cities_options';
callbackDat = {argsSetCitiesOptions, handleSetCitiesOptions};

% Second callback: sets the initial value when the option changes
argsSetCitiesValue = {argsOut('cities-radio', 'value'), ...
    argsIn('cities-radio', 'options') };
handleSetCitiesValue = 'set_cities_value';
callbackDat{2,1} = argsSetCitiesValue;
callbackDat{2,2} = handleSetCitiesValue;

% Third callback: display the selected value of each component
argsSetDisplayChildren = {argsOut('display-selected-values', 'value'), ...
    argsIn('countries-radio', 'value'),  argsIn('cities-radio', 'value') };
handleSetDisplayChildren = 'set_display_children';
callbackDat{3,1} = argsSetDisplayChildren;
callbackDat{3,2} = handleSetDisplayChildren;

% Start app.
app = startDash(uigrid, 8057, callbackDat);


%--------------------------------%
%      set_cities_options.m      %
%--------------------------------%

function output = set_cities_options(selected_country)
    all_options = struct(...
        'America', {{'New York City', 'San Francisco', 'Cincinnati'}},...
        'Canada', {{'Montréal', 'Toronto', 'Ottawa'}});
    
    cities = all_options.(selected_country);
    output = {length(cities)};
    for i = 1:length(cities)
        output{i} = struct('label', string(cities{i}), 'value', string(cities{i}));
    end

    output = char(jsonencode({output}));
end


%------------------------------%
%      set_cities_value.m      %
%------------------------------%

function output = set_cities_value(available_options)
    output = jsonencode({available_options{1}.('value')});
end


%----------------------------------%
%      set_display_children.m      %
%----------------------------------%

function output = set_display_children(selected_country, selected_city)  
    output = jsonencode({sprintf('%s is a city in %s', selected_city, selected_country)});
end
