---
url: /live-updates
name: Live Updates
description:
    "Update your apps on page load or on a predefined interval (e.g. every 5 seconds)"
icon: loop-arrow.svg
languages:
  - python
  - julia
  - r
  - fsharp
---

# ![](/assets/images/language_icons/matlab_50px.svg) Live Updating Components

## The `dcc.Interval` Component

Components in Dash usually update through user interaction like
selecting a dropdown, dragging a slider, or hovering over points.

If you're building an application for monitoring, you may want to update
components in your application every few seconds or minutes.

The `dcc.Interval` element allows you to update components
on a predefined interval. The `n_intervals` property is an integer that is
automatically incremented every time `interval` milliseconds pass.
You can listen to this variable inside your app's `callback` to fire
the callback on a predefined interval.

This example pulls data from live satellite feeds and updates the graph
and the text every second.



{{oss {{dash-club}} }}





