---
url: /installation
name: Installation
description:
    "How to install and upgrade Dash"
icon: tools.svg
languages:
  - python
  - r
  - fsharp
  - matlab
  - julia
---
# ![](/assets/images/language_icons/matlab_50px.svg) Dash Installation

Make sure you have a compatible [Python version installed](https://www.mathworks.com/content/dam/mathworks/mathworks-dot-com/support/sysreq/files/python-compatibility.pdf). If your Python version is different, consider downgrading it or using [pyenv](https://github.com/pyenv/pyenv).

In your terminal, install `dash`.

```shell
pip install dash
```

This also brings along the `plotly` graphing
library. This library is
under active development, so install and upgrade frequently.






Install [dash-bootstrap-components](https://github.com/facultyai/dash-bootstrap-components):
```shell
pip install dash-bootstrap-components
```

Download and uncompress the [Plotly Graphing Library for MATLAB®](https://github.com/plotly/MATLAB-api/archive/master.zip). Then, install it with:

```shell
cd ~/Downloads/plotly-graphing-library-for-matlab-master
plotlysetup_offline()
```

Add `dash_matlab` folder to your MATLAB® [path](https://www.mathworks.com/help/matlab/ref/addpath.html):
```shell
addpath('~/dash_matlab/helper_functions')
```

(You can also do this in the [GUI](https://ibb.co/HYgsPGL), add with [subfolders](https://ibb.co/tCgv3rC) dash_matlab).


These docs are running `dash` version `{{eval dash.__version__` ||julia `1.0.0` ||r `0.9.1`}}.

MATLAB® 2021 is the recommended version for this library.



{{oss {{dash-club}} }}



{{oss
{{import /reusable_components/WorkspaceBlurb.md}}
}}
