%%%%%%%%%%%
%% app.m %%
%%%%%%%%%%%

terminate(pyenv);
clearvars;

% Read data file
data = readtable('https://git.io/JgqCd', 'PreserveVariableNames', true);

data.index = (1:1:height(data))'; % Add index column
data.Properties.VariableNames{end} = 'Aindex';
data = data(:, sort(data.Properties.VariableNames));

PAGE_SIZE = 5;

% Create ui elements
uiFigure = uifigure('visible', 'off');
size = [12, 12];
uiGrid = uigridlayout(uiFigure, size);

dataTable = uitable(uiGrid, 'ColumnName', data.Properties.VariableNames,...
    'Data', data, 'visible', 'off', 'Tag', 'table-paging-and-sorting');

% Define columns
lncols = width(dataTable.Data);
columns = {lncols};

for i=1:lncols
    col = data.Properties.VariableNames{i};
    columns{i} = struct('name', col, 'id', col, 'deletable', true);
end

columns = {columns};
dataTable.UserData = struct(...
    'columns', columns,...
    'page_current', 0,...
    'page_size', PAGE_SIZE,...
    'page_action', 'custom',...
    'sort_action', 'custom',...
    'sort_mode', 'single',...
    'sort_by', {{}});

% Callback
args = {...
    argsOut('table-paging-and-sorting','data'),...
    argsIn('table-paging-and-sorting','page_current'),...
    argsIn('table-paging-and-sorting','page_size'),...
    argsIn('table-paging-and-sorting','sort_by')};
handle = 'update_table';
callbackDat = {args, handle};

% Run the app
startDash(uiGrid, 8057, callbackDat);

%%%%%%%%%%%%%%%%%%%%
%% update_table.m %%
%%%%%%%%%%%%%%%%%%%%

function df = update_table(page_current, page_size, sort_by)
    data1 = readtable('https://git.io/JgqCd', 'PreserveVariableNames', true);

    data1.index = (1:1:height(data1))'; % Add index column
    data1.Properties.VariableNames{end} = 'Aindex';
    data2 = data1(:, sort(data1.Properties.VariableNames));
    
    if size(sort_by)
        if strcmp(sort_by{1}.direction, 'asc')
            direction = 'ascend';
        else
            direction = 'descend';
        end

        df = sortrows(data2, sort_by{1}.column_id, direction);
    else
        df = data2;
    end   

    df = df(page_current*page_size+1:(page_current+1)*page_size,:);
    df = char(jsonencode({df}));

end