%%%%%%%%%
% app.m %
%%%%%%%%%

terminate(pyenv);
clearvars;

% Title
title = Html('H1', {'Dash Tabs component demo'});

% Create tab group with tabs
uiFig = uifigure('visible', 'off');
tabGroup = uitabgroup(uiFig);
tabOne = uitab(tabGroup,'Title','Tab One', 'Tag', 'tab-1-example-graph');
tabTwo = uitab(tabGroup,'Title','Tab Two', 'Tag', 'tab-2-example-graph');

tabGroupComponent = ui2dash(tabGroup, 'tabs-example-graph');

myDiv = Html('Div', {'id', 'tabs-content-example-graph'});

components = {title, tabGroupComponent, myDiv};

% Callbacks
args = {argsOut('tabs-content-example-graph', 'children'),...
    argsIn('tabs-example-graph', 'value')};
handle = 'render_content';

callbackDat = {args, handle};

% Start app
startDash(components, 8057, callbackDat, 'SOLAR');

%%%%%%%%%%%%%%%%%%%%
% render_content.m %
%%%%%%%%%%%%%%%%%%%%

function outDiv = render_content(tab)
    figure('visible', 'off');
    if strcmp(tab, 'tab-1-example-graph')        
        bar([1 2 3], [3 1 2]);
        H3 = Html('H3', {'Tab content 1'});
    elseif strcmp(tab, 'tab-2-example-graph')
        bar([1 2 3], [5 10 6]);
        H3 = Html('H3', {'Tab content 2'});
    end
    
    fig = fig2plotly(gcf, 'offline', true, 'open', false, 'Visible', false);
    addtheme(fig, 'plotly_dark');
    myFig = Html('Center', {plotlyfig2dash(fig, 'my-fig')});
    
    myDiv = Html('Div', {{H3, myFig}});
    
    outDiv = plotlyJsonEncoder(myDiv);
end
