terminate(pyenv);
clearvars;

% Read data files
modelData = readBioData('https://git.io/JV8hc', 'noutf8');
stylesData  = readBioData('https://git.io/JV4er', 'noutf8');

componentMolecule = dashBio('Molecule3dViewer', {...
        'styles', stylesData,...
        'modelData', modelData,...
        'labels', {...
            struct(...
                'text', 'Residue Name GLY1',...
                'fontColor', 'red',...
                'font', 'Courier New, monospace'),...
            struct(...
                'text', 'Residue Name A',...
                'position', struct(...
                    'x', 15.407, 'y', -8.432, 'z', 6.573))}});
    
components = {componentMolecule};

% Run the app
startDash(components, 8057);
