terminate(pyenv);
clearvars;

% Read data file
data = readBioData('https://git.io/J2Bgu');
circos_graph_data = jsondecode(char(data));

component = dashBio('Circos', {...
        'layout', circos_graph_data.('GRCh37'),...
        'tracks', {struct(...
            'type', 'CHORDS',...
            'data', circos_graph_data.('chords'))},...
        'config', struct(...
            'innerRadius', 40,...
            'outerRadius', 200)});
    
components = {component};

% Run the app
startDash(components, 8057);
