%--------------------------%
%      multi-inputs.m      %
%--------------------------%

terminate(pyenv);
clearvars; % Removes all variables from the currently active workspace.

% Read data file.
countryIndicators = readtable('country_indicators.csv');
allInds = unique(countryIndicators.IndicatorName);

uifig = uifigure('visible', 'off');
size = [12, 12];
uigrid = uigridlayout(uifig, size);

% Create ui elements.
dropdownLeft = uidropdown(uigrid, 'Tag', 'xaxis-column', 'Items', allInds, 'Value', allInds{1});
dropdownLeft.Layout.Column = [1, 6];

dropdownRight = uidropdown(uigrid, 'Tag', 'yaxis-column', 'Items', allInds, 'Value', allInds{2});
dropdownRight.Layout.Column = [7, 12];

buttonGroupLeft = uibuttongroup(uigrid, 'Tag', 'xaxis-type');   
buttonGroupLeft.Layout.Column = [1, 4];
radioButtonLeftLinear = uiradiobutton(buttonGroupLeft, 'Text', 'Linear');
radioButtonLeftLog = uiradiobutton(buttonGroupLeft, 'Text', 'Log');

buttonGroupRight = uibuttongroup(uigrid, 'Tag', 'yaxis-type');   
buttonGroupRight.Layout.Column = [7, 10];
radioButtonRightLinear = uiradiobutton(buttonGroupRight, 'Text', 'Linear');
radioButtonRightLog = uiradiobutton(buttonGroupRight, 'Text', 'Log');

% Initial plot.
ax = axes(uigrid);
ax.Layout.Row = [3, 11];
ax.Layout.Column = [2, 12];

fig = figure('visible', 'off');
tics = unique(countryIndicators.Year);
subtab = countryIndicators(countryIndicators.Year == tics(1), :);

subtabX = subtab(cellfun(@(x) isequal(x,allInds{1}), subtab.IndicatorName), : );
subtabY = subtab(cellfun(@(x) isequal(x,allInds{2}), subtab.IndicatorName), : );
scatter(ax, subtabX.Value,  subtabY.Value, categorical(subtabY.Value), 'filled',...
    'MarkerEdgeColor', 'b', 'MarkerFaceColor', [0 0.5 0.5]);
ax.Tag = 'indicator-graphic';

% Slider
slider = uislider(uigrid, 'Tag', 'year-slider', 'MajorTicks', tics);    

% Define the callbacks.
args = { argsOut('indicator-graphic', 'figure'), ...
    argsIn('xaxis-column', 'value'), ...
    argsIn('yaxis-column', 'value'), ...
    argsIn('xaxis-type', 'value'), ...
    argsIn('yaxis-type', 'value'), ...
    argsIn('year-slider', 'value') };  

handle = 'update_graph';
callbackDat = {args, handle};

% Run the app.
sliderApp = startDash(uigrid, 8057, callbackDat);


%--------------------------%
%      update_graph.m      %
%--------------------------%

function plotlyFig = update_graph(xaxis_column_name, yaxis_column_name, ...
                 xaxis_type, yaxis_type,  year_value)

    countryIndicators = readtable('country_indicators.csv');
    
    if year_value == 0
        year_value = min(countryIndicators.Year);
    end
    
    fig = figure('visible', 'off');
    subtab = countryIndicators(countryIndicators.Year == year_value, :);
    subtabX = subtab(cellfun(@(x) isequal(x, xaxis_column_name), subtab.IndicatorName), : );
    subtabY = subtab(cellfun(@(x) isequal(x, yaxis_column_name), subtab.IndicatorName), : );
    scatter(subtabX.Value,  subtabY.Value, 60, 'filled',...
        'MarkerEdgeColor', 'b', 'MarkerFaceColor', [0 0.5 0.5]);
    set(gca,'xscale', xaxis_type)
    set(gca,'yscale', yaxis_type)
    xlabel(gca, xaxis_column_name)
    ylabel(gca, yaxis_column_name)
    
    fig = fig2plotly(gcf, 'offline', true, 'open', false, 'Visible', false);
    addtheme(fig, 'plotly_dark');
    
    plotlyFig1 = {struct('data', {fig.('data')}, 'layout', fig.('layout'))};
    plotlyFig = char(jsonencode(plotlyFig1));
end
