terminate(pyenv);
clearvars;

% Read data file
data = readtable('https://git.io/Jgvhr');

data = data((1:7),:); % Select first 7 rows

% Create ui elements
uiFigure = uifigure('visible', 'off');
size = [12, 12];
uiGrid = uigridlayout(uiFigure, size);

dataTable = uitable(uiGrid, 'ColumnName', data.Properties.VariableNames,...
    'Data', data, 'visible', 'off', 'Tag', 'table');

tooltip_conditional = {1};
tooltip_conditional{1} = struct(...
    'if', struct('filter_query','{ProviderName} contains "HOSPITAL"'),...
    'type','markdown',...
    'value','This row is significant.');
tooltip_conditional = {tooltip_conditional};

style_data_conditional = {1};
style_data_conditional{1} = struct(...
    'if', struct('filter_query','{ProviderName} contains "HOSPITAL"'),...
    'backgroundColor','#0074D9',...
    'color','white',...
    'textDecoration','underline',...
    'textDecorationStyle','dotted');
style_data_conditional = {style_data_conditional};

dataTable.UserData = struct(...
    'tooltip_conditional', tooltip_conditional,...
    'style_data_conditional', style_data_conditional,...
    'tooltip_delay', 10,... % In ms. If set to 0 tooltip is not shown...
    'tooltip_duration', -1); % Use -1 to prevent the tooltip from disappearing

% Run the app
startDash(uiGrid, 8057);