---
url: /datatable/data-formatting
name: Number Formatting
description:
    "`DataTable` is an interactive table that supports rich styling, 
    conditional formatting, editing, sorting, filtering, and more."
languages:
  - python
  - fsharp
---

# ![](/assets/images/language_icons/matlab_50px.svg) DataTable - Number Formatting

`DataTable` offers extensive number formatting and localization possibilities with the columns nested prop  and
table-wide localization prop .

Most formatting and localization for columns can be done through the 
and  helpers but it's also possible to use the `d3-format`
`specifier` and `locale` directly.



See [d3-format](https://github.com/d3/d3-format) for additional syntax details.

## Using FormatTemplate

The FormatTemplate provides the following predefined templates:

- Money
- Percentage

{{example data_formatting_formattemplate}}

## Using Format Helper

### Group

Grouping is defined with the format nested props `group` and `groups`.
`group` takes values  or  to toggle digit grouping.
`groups` takes a list of numbers used to define the digits grouping pattern.
If the number has more digits than what's defined in `groups`, it cycles through the
list again until it runs out of numbers to group.

{{example data_formatting_format_group}}

### Align and Fill

Alignment and filling is defined with the format nested props `align`, `fill`, and .
The `align` helper takes values , , and .
`fill` is single character that will be used for filling.
 is the minimum length of the filled string.
If the formatted number requires more space than  allows for, it will do so.

{{example data_formatting_format_fill}}

### Padding and Padding Width

Padding and padding width is defined with the format nested props `padding` and  and they behave similarly
to `fill` and , but do not allow alignment.

{{example data_formatting_format_padding}}

### Precision and Scheme

{{example data_formatting_format_precision}}

### Sign

When to display a sign and what type of sign to display is defined with the format nested prop `sign`.
The `Sign` helper takes values  (show sign when negative),  (always show sign),  (when negative)

{{example data_formatting_format_sign}}

### Symbol

Displaying of symbols is defined with the format nested prop `symbol` and the prefix/suffix symbols are defined with the locale nested prop `symbol`.
The `Symbol` helper takes values  and .
The locale `symbol` nested prop is a list of strings of length 2 of the form `[prefix, suffix]`. Strings in symbol can be of any length.

{{example data_formatting_format_symbol}}

## Localization

{{example data_formatting_format_localization}}