---
url: /dash-core-components/input
name: Input
description:
    "Use the dcc.Input component to create input fields for text, numbers, passwords, and more, allowing dynamic user input."
languages:
    - python
    - julia
    - fsharp
    - matlab
---
# ![](/assets/images/language_icons/matlab_50px.svg) dcc.Input


The `dcc.Input` component creates input fields for text, numbers, passwords, and more, allowing dynamic user input.


## Examples

Find a few usage examples below.



### Supported Input Types

{{example input_all_types}}

{{oss {{dash-club}} }}

### Debounce Delays the Input Processing

{{example input-basic}}

### Number Input

Number type is now close to native HTML5 `input` behavior across
browsers. We also apply a strict number casting in callbacks:
valid number converts into corresponding number types, and invalid number
converts into "NaN". E.g.
```matlab
Dcc('Input', {'id','range','type','number','min',2,'max',10,'step',1})
```

type 3 and 11 will return respectively integer three and `NaN` in Matlab callbacks.

>**Important Notice re Integer vs Float**:
There is a limitation when converting numbers like 1.0 or 0.0: the
corresponding number type in callbacks is **Integer** instead of **Float**.
Add extra guard casting like `double` within callbacks if needed.

{{example input_number_type}}

------------------------

{{reference dcc.Input}}