%%%%%%%%%
% app.m %
%%%%%%%%%

terminate(pyenv);
clearvars;

dashDialog = Dcc('ConfirmDialogProvider', {...
    'children', Html('Button', {'Click Me'})...
    'id', 'danger-danger-provider',...
    'message', 'Danger danger! Are you sure you want to continue?'});

dashDiv = Html('Div', {'id', 'output-provider'});

components = {dashDialog, dashDiv};

% Callbacks
args = {argsOut('output-provider', 'children'), ...
    argsIn('danger-danger-provider', 'submit_n_clicks') };
handle = 'update_output';
callbackDat = {args, handle};

% Start app
startDash(components, 8057, callbackDat, 'SOLAR');

%%%%%%%%%%%%%%%%%%%
% update_output.m %
%%%%%%%%%%%%%%%%%%%

function outTxt = update_output(submit_n_clicks)
    if ~strcmp(string(submit_n_clicks), 'NaN')
        outTxt = sprintf(['It was dangerous but we did it!\n',...
            'Submitted %d times'], submit_n_clicks);
    else
        outTxt = '';
    end
    outTxt = jsonencode({outTxt});
end
