---
url: /performance
name: Performance
description: "There are three main ways to speed up Dash apps: caching, using WebGL chart types, and implementing clientside callbacks."
icon: multiple.svg
languages:
    - python
---

# ![](/assets/images/language_icons/matlab_50px.svg) Performance
This chapter contains several recommendations for improving the performance
of your dash apps.

The main performance limitation of dash apps is likely the callbacks in
the application code itself. If you can speed up your callbacks, your app
will feel snappier.

***


## Graphs
[Plotly.js](https://github.com/plotly/plotly.js) is pretty fast out of the box.

Most plotly charts are rendered with SVG. This provides crisp rendering,
publication-quality image export, and wide browser support.
Unfortunately, rendering graphics in SVG can be slow for large datasets
(like those with more than 15k points).
To overcome this limitation, plotly.js has WebGL alternatives to
some chart types. WebGL uses the GPU to render graphics.

The high performance, WebGL alternatives include:
- `scattergl`: A webgl implementation of the `scatter` chart type. [Examples](https://plotly.com/python/webgl-vs-svg/), [reference](https://plotly.com/python/reference/#scattergl)
- `pointcloud`: A lightweight version of `scattergl` with limited customizability but even faster rendering. [Reference](https://plotly.com/python/reference/#pointcloud)
- `heatmapgl`: A webgl implementation of the `heatmap` chart type. [Reference](https://plotly.com/python/reference/#heatmapgl)


Currently, Dash redraws the entire graph on update using the `plotly.js`
`newPlot` call. The performance of updating a chart could be improved
considerably by introducing `restyle` calls into this logic. If you or
your company would like to sponsor this work,
[get in touch](https://plotly.com/products/consulting-and-oem/).

***

## Clientside Callbacks
Clientside callbacks execute your code in the client in JavaScript rather than
on the server in Python.

Read more about clientside callbacks in the [clientside callbacks](/clientside-callbacks)
chapter.

## Background Callbacks
In addition to providing memoization caching, background callbacks can help you improve your app scalability by moving computations from the Dash app server to a background job queue.
See the [Background Callbacks chapter](/background-callbacks) for more information on how to implement these.

## Partial Property Updates
With <dccLink href="/partial-properties" children="partial property updates"/>, introduced in Dash 2.9, you can improve your app performance by only updating the parts of a property that you want to change. For example, the color of data points on a graph, but not the underlying data. See the <dccLink href="/partial-properties" children="partial property updates"/> page for more information.

## Data Serialization
New with Dash 2.0, you can use `orjson` to speed up serialization to JSON and in turn improve your callback performance. For an app that runs complex callbacks involving a large amount of data points, you could see a performance increase of up to 750 ms.
[Learn more about `orjson` here](https://github.com/ijl/orjson) or install it with `pip install orjson`.

`orjson` is completely optional: If it exists in the environment, then Dash will use it; if not, Dash will use the default `json` library.

## Sponsoring Performance Enhancements
There are many other ways that we can improve the performance of dash apps,
like caching front-end requests, pre-filling the cache, improving plotly.js's
webgl capabilities, reducing JavaScript bundle sizes, and more.

Historically, many of these performance related features have been funded
through company sponsorship. If you or your company would like to sponsor
these types of enhancements, [please get in touch](https://plotly.com/products/consulting-and-oem/),
we'd love to help.
