---
url: /slicer
name: Overview & Reference
description:
    "A volume slicer for Dash."
icon: maximize.svg
languages:
    - python
---

# ![](/assets/images/language_icons/matlab_50px.svg) Introduction to Dash Slicer

The ``dash_slicer`` library provides an easy way to visualize 3D image data
by slicing along one dimension. Multiple views on the same data can be linked,
to help with navigation. There is also support for mask overlays.

Install Dash Slicer with:

```pip install -U dash-slicer```

The source is on GitHub at [plotly/dash-slicer](https://github.com/plotly/dash-slicer).

## Guide

### A first example

Let's get started with a simple example.
(The examples on this page are built with dash-slicer version 0.3.0)

{{example slicer_example1}}

In the code above, we first load a 3D numpy array (a volumetric image). Then
we instantiate a `VolumeSlicer` object with that data. This object is not
a Dash component, but has attributes that are. We place its `graph` and
`slider` in the layout, as well as a handful of `Store` components that the
slicer needs to function.

The graph's `scrollZoom` config option is turned off here, because
it would make the plot grab scroll events as you scroll down this page.

If the server is run in debug mode, consider setting `dev_tools_props_check`
to False, because it has a big impact on the performance.

### Multiple slicers

In the next example, we create multiple slicers, one for each dimension,
and put them in a layout, just like we did in the previous example.

{{example slicer_example2}}

You can see how each view contains indicator lines, which show the
position of the other slicers. Each slicer has a certain color
(which is auto-selected, but can also be provided), which is shown
in the corners around the image. The same color is used to draw the
slicer's indicator lines in the other views.

Slicers indicate each-other's position if they are linked based on their
`scene_id`. This is a property that can be provided when you
instantiate a `VolumeSlicer`. By default, the `scene_id` is derived
from the volume. That's why the linking in this example works: each
slicer is given the same numpy array object. By explicitly setting
the `scene_id`, multiple views on different data (e.g. MRI and CT) can
be linked as well.

In addition to using the sliders, you can click in one of the
views to make the other views go to the clicked location. Try it!
Thanks to this navigation mode, you can optionally hide sliders in
the layout when two or more views are present (see the `VolumeSlicer.slider`
property ).

### Anisotropic data

In the next example, we make the data non-isotropic. This means
that the distance between voxels is not equal for all dimensions.
The voxel-spacing can be provided via the `spacing` argument.
Similarly, an `origin` can also be provided. You can zoom into the
view on the right to see that the voxels are elongated.

{{example slicer_example3}}

### Reacting to the slicer state

This example illustrates how your application can react to the slicer's
position and view by using the `state` store as an input. Note that the
id of this store is a dict, which makes it possible to write a
[pattern matching Input](https://dash.plotly.com/pattern-matching-callbacks)
to collect the states of all slicers with a certain scene_id.
See the reference docs for details.

{{example slicer_example4}}

### More examples

More examples are available at the
[dash-slicer repository](https://github.com/plotly/dash-slicer/tree/main/examples).