---
url: /datatable/tooltips
name: DataTable Tooltips
description:
    "`dash_table.DataTable` is an interactive table that supports rich styling,
    conditional formatting, editing, sorting, filtering, and more."
languages:
  - python
  - julia
  - matlab
---

# ![](/assets/images/language_icons/matlab_50px.svg) DataTable Tooltips

DataTable Tooltips allow you to provide additional information about table
cells or headers when hovering your mouse over cells.

These properties can be used to specify `DataTable` tooltips:
- `tooltip`: Column based tooltip configuration applied to all rows
- `tooltip_conditional`: Conditional tooltips overriding `tooltip`
- `tooltip_data`: Statically defined tooltip for each row/column combination
- `tooltip_header`: Statically defined tooltip for each header column and optionally each header row
- `tooltip_delay`: Table-wide default delay before the tooltip is displayed
- `tooltip_duration`: Table-wide default duration before the tooltip disappears. Set to -1 to prevent the tooltip from disappearing.

See <dccLink children="DataTable Reference" href="/datatable/reference"/> for detailed descriptions.

## Tooltips on Individual Cells

Use tooltips on individual cells if your data is abbreviated, cut-off,
or if you'd like to display more context about your data.

This example displays the same data in the cell within the header:

{{example tooltips_individual_cells1}}

The shape of the `toolip_data` is a list of dictionaries, where
each dictionary's key matches the `column.id`  and each dictionary's
value is a dict with `value` & `type`. Alternatively, it can be a single
value and `type` will be a string instead of `markdown`.

{{example tooltips_individual_cells2}}

This example displays different content in each column than what
is displayed in the cell.

{{example tooltips_individual_cells3}}

## Tooltips in Column Headers

If your column headers are abbreviated or cut-off
(<dccLink children="See DataTable Width" href="/datatable/width"/>),
then place a tooltip in the header with `tooltip_header`.

We recommend providing some light styling to the header to indicate that
it is "hoverable". We use the dotted underline with `text-decoration`.
This [isn't supported in IE11](https://caniuse.com/?search=text-decoration-style).

In this example, the headers are cut-off because they are too long.
Our tooltip is the original name of the column.

{{example tooltips_column_headers1}}

Alternatively, you can specify a different name within `tooltip_header`
or specify a subset of columns:

{{example tooltips_column_headers2}}

_Note that ellipses aren't displayed in headers. This is a bug, subscribe to
[plotly/dash-table#735](https://github.com/plotly/dash-table/issues/735)
for details._

If your `DataTable` has multiple rows of headers, then use a list
as the value of the `tooltip_header` items.

For merged cells, the values must repeat in each cell.

{{example tooltips_column_headers3}}

## A Single Tooltip in the Column

As an alternative or in addition to column header tooltips, place a
tooltip to appear on the entire column with the `tooltip` property.

This can also be helpful with large tables where the user
may lose track of the column headers.

If the tooltip is specified for both headers and cells, you can use
the `use_with` property instead of specifying a separate `tooltip_header`
and `tooltip`.

{{example tooltips_single_in_column}}

## Conditional Tooltips

Tooltips can also be customized based on conditions.
The `tooltip_conditional` has the same syntax as the `style_data_conditional`
property, see the <dccLink href="/datatable/conditional-formatting" children="conditional formatting"/>
chapter for many examples.

If both `tooltip_conditional` and `tooltip` would display a tooltip for
a cell, the conditional tooltip takes priority. If multiple conditions match the
data row, the last match has priority.

{{example tooltips_conditional}}

## Images in Tooltips

Markdown supports images with this syntax: `![alt](src)`
where `alt` refers to the image's [alt text](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/Img)
and `src` is the path to the image (the `src` property).

The `src` can refer to images within your project's "assets" folder
or absolute URLs. If referring to an image in the `assets` folder,
we recommend using `dash.get_relative_path` so that the image URL
is correct when working locally and when deploying to Dash Enterprise.

{{example tooltips_images}}

## Tables in Tooltips

Markdown supports tables with a syntax that looks like this:
```
| City       | Value     | Return     |
| :------------- | :----------: | -----------: |
|  Montreal   | 41,531    | 431.245 |
| Seattle   | 53,153 | 12.431 |
```

| City       | Value     | Return     |
| :------------- | :----------: | -----------: |
|  Montreal   | 41,531    | 431.245 |
| Seattle   | 53,153 | 12.431 |

This can be specified within a table's value:

{{example tooltips_table}}

## Styling Tooltips

Tooltips can be styled with the `dash-tooltip` (container) and `dash-table-tooltip` (content) CSS classes.
This can be specified within a CSS file inside your `assets/` folder
or within the table itself with the `css` property.

{{example tooltips_styles}}

## Customizing Delay & Duration

Set `tooltip_delay` to `0` for the tooltips to appear immediately.

Set `tooltip_duration` to -1 in order for the tooltips to remain
visible while you are hovering over them. Otherwise, they will disappear
after `tooltip_duration` milliseconds.