---
url: /cytoscape/events
name: User Interactions
description: "Overview of user-interaction events that trigger callbacks in Dash, and how to use them to update the Cytoscape component."
languages:
    - python
    - julia
---

# ![](/assets/images/language_icons/matlab_50px.svg) Cytoscape Event Callbacks

In <dccLink href="/cytoscape/callbacks" children="part 4"/>, we showed how to update Cytoscape with
other components by assigning callbacks that output to `'elements',
'stylesheet', 'layout'`. Moreover, it is also possible to use properties
of Cytoscape as an input to callbacks, which can be used to update other
components, or Cytoscape itself. Those properties are updated (which fires
the callbacks) when the user interact with elements in a certain way,
which justifies the name of event callbacks. You can find props such as
`tapNode`, which returns a complete description of the node object when
the user clicks or taps on a node, `mouseoverEdgeData`, which returns only
the data dictionary of the edge that was most recently hovered by the user.
The complete list can be found in the [Dash Cytoscape Reference](/cytoscape/reference).

## Simple callback construction

Let's look back at the same city example as the previous chapter:

{{example simple_callback_construction}}

This time, we will use the `tapNodeData` properties as input
to our callbacks, which will simply dump the content into an :

{{example event_callbacks}}

Notice that the  is updated every time you click or tap a node,
and returns the data dictionary of the node. Alternatively, you can use
`tapNode` to obtain the entire element specification (given as a
dictionary), rather than just its `data`.

## Click, tap and hover

Let's now display the data generated whenever you click or hover over a node
or an edge. Simply replace the previous layout and callbacks by this:

{{example event_callbacks_2}}

## Selecting multiple elements

Additionally, you can also display all the data currently selected, either
through a box selection (Shift+Click and drag) or by individually selecting
multiple elements while holding Shift:

{{example event_callbacks_3}}

## Advanced usage of callbacks

Those event callbacks enable more advanced interactions between components.
In fact, you can even use them to update other `Cytoscape` arguments. The
[`usage-stylesheet.py`](https://github.com/plotly/dash-cytoscape/blob/master/usage-stylesheet.py)
example (hosted on the `dash-cytoscape` Github repo) lets you click to change the
color of a node to purple, its targeted
nodes to red, and its incoming nodes to blue. All of this is done using a
single callback function, which takes as input the `tapNode` prop of the
`Cytoscape` component along with a few dropdowns, and outputs to the
`stylesheet` prop. You can try out this
[interactive stylesheet demo](https://dash-gallery.plotly.host/cytoscape-stylesheet)
hosted on [Dash Enterprise](https://plotly.com/products/dash/).


}}


Additionally, [`usage-elements.py`](https://github.com/plotly/dash-cytoscape/blob/master/usage-elements.py)
lets you progressively expand your graph
by using `tapNodeData` as the input and `elements` as the output.

The app initially pre-loads the entire dataset, but only loads the graph
with a single node. It then constructs four dictionaries that maps every
single node ID to its following nodes, following edges, followers nodes,
followers edges.

Then, it lets you expand the incoming or the outgoing
neighbors by clicking the node you want to expand. This
is done through a callback that retrieves the followers (outgoing) or following
(incoming) from the dictionaries, and add the to the `elements`.
[Click here for the online demo](https://dash-gallery.plotly.host/cytoscape-elements).


}}


}}

To see more examples of events, check out the [event callbacks demo](https://dash-gallery.plotly.host/cytoscape-events)
(the source file is available as [`usage-events.py`](https://github.com/plotly/dash-cytoscape/blob/master/usage-events.py) on the project repo)
and the <dccLink href="/cytoscape/reference" children="Cytoscape references"/>.

