%%%%%%%%%
% app.m %
%%%%%%%%%

terminate(pyenv);
clearvars;

tabs_styles = struct('height', '44px');

tab_style = struct(...
    'borderBottom', '1px solid #d6d6d6',...
    'padding', '6px',...
    'fontWeight', 'bold');

tab_selected_style = struct(...
    'borderTop', '1px solid #d6d6d6',...
    'borderBottom', '1px solid #d6d6d6',...
    'backgroundColor', '#119DFF',...
    'color', 'white',...
    'padding', '6px');

tab1 = Dcc('Tab', {...
    'label', 'Tab 1',...
    'value', 'tab-1',...
    'style', tab_style,...
    'selected_style', tab_selected_style});

tab2 = Dcc('Tab', {...
    'label', 'Tab 2',...
    'value', 'tab-2',...
    'style', tab_style,...
    'selected_style', tab_selected_style});

tab3 = Dcc('Tab', {...
    'label', 'Tab 3',...
    'value', 'tab-3',...
    'style', tab_style,...
    'selected_style', tab_selected_style});

tab4 = Dcc('Tab', {...
    'label', 'Tab 4',...
    'value', 'tab-4',...
    'style', tab_style,...
    'selected_style', tab_selected_style});

myTabs = Dcc('Tabs', {...
    'children', {tab1, tab2, tab3, tab4},...
    'id', 'tabs-styled-with-inline',...
    'value', 'tab-1',...
    'style', tabs_styles});
        

myDiv = Html('Div', {'id', 'tabs-content-inline'});


components = {myTabs, myDiv};

% Callbacks
args = {argsOut('tabs-content-inline', 'children'),...
    argsIn('tabs-styled-with-inline', 'value')};
handle = 'render_content';

callbackDat = {args, handle};

% Start app
startDash(components, 8057, callbackDat, 'SOLAR');

%%%%%%%%%%%%%%%%%%%%
% render_content.m %
%%%%%%%%%%%%%%%%%%%%

function outDiv = render_content(tab)
    if strcmp(tab, 'tab-1')        
        H3 = Html('H3', {'Tab content 1'});
    elseif strcmp(tab, 'tab-2')
        H3 = Html('H3', {'Tab content 2'});
    elseif strcmp(tab, 'tab-3')
        H3 = Html('H3', {'Tab content 3'});
    elseif strcmp(tab, 'tab-4')
        H3 = Html('H3', {'Tab content 4'});
    end
    outDiv = Html('Div', {H3});
    outDiv = plotlyJsonEncoder(outDiv);
end
