---
url: /dash-core-components/markdown
name: Markdown
description:
    "The dcc.Markdown component renders Markdown text, allowing for easy formatting and styling of text content."
languages:
    - python
    - julia
    - matlab
    - fsharp
---

# ![](/assets/images/language_icons/matlab_50px.svg) dcc.Markdown

`dcc.Markdown` is a component for rendering Markdown text, allowing for easy formatting and styling of text content in your Dash app.

## Examples

Find a few usage examples below.



### Headers

{{example headers}}

### Emphasis

{{example emphasis}}

### Lists
{{example lists}}

### Block Quotes

{{example block_quotes}}

### Links

{{example links}}

### Link Target

> `link_target` is available in Dash 2.4 and later.

Using `link_target` you can set the HTML [`target` attribute](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/a#attr-target) for links in your Markdown component.
In this example, we set `link_target="_blank"`. When selected, the Dash User Guide link now opens in a new tab or window.

{{example link_target}}

### Inline Code

Text surrounded by single backticks (\`) renders as inline code.

{{example inline_code}}

Only certain languages are supported by default in `dcc.Markdown`. For more details about how to customize the
languages and color schemes, refer to <dccLink href="/external-resources#syntax-highlighting-with-markdown" children="Syntax Highlighting With Markdown"/>
in Adding CSS & JS and Overriding the Page-Load Template.

### LaTeX

`dcc.Markdown` supports rendering LaTeX. It uses [MathJax version 3.2](https://docs.mathjax.org/en/v3.2-latest/) and can be enabled by setting `mathjax=True` on the component. For inline math content, use `$` delimiters. For math content that you want to display as a block (usually multi-line content), use `$$`. If you need a literal `$`, use the HTML entity `&#36;`

{{example mathjax_markdown}}

For an introduction to LaTeX math, see [LaTeX/Mathematics](https://en.wikibooks.org/wiki/LaTeX/Mathematics).

***

{{reference dcc.Markdown}}
