---
url: /dash-core-components/graph
name: Graph
description:
    "Use the dcc.Graph component for rendering interactive Plotly graphs, enabling dynamic data visualization in your app."
languages:
    - python
    - julia
    - fsharp
---
# ![](/assets/images/language_icons/matlab_50px.svg) dcc.Graph

The `dcc.Graph` component can be used to render any plotly-powered data visualization, passed as the `figure` argument.

## Primer on Plotly Graphing Library

- The [**Plotly Graphing Library**](), known as the  `plotly`, generates "figures".  These are used in `dcc.Graph` with e.g.  with `fig` a plotly figure.
- **To get started with plotly**, learn how its documentation is organized:
    1. Learn the architecture of the `figure`: 
    2. Every chart type has a set of examples at a unique URL. Familiarize yourself with the structure of these pages. Google is your friend. For example "Histograms in " is documented at 
    
    
    4. Every aspect of a chart is configurable. Read through 1 to understand the low-level `figure` interface and how to modify the properties of a generated figure. Once you understand it, view _all_ of the properties by visiting the "Figure Reference" page at .
    
    
* Plotly supports 40-50 different chart types. Learn more by navigating .
* In development, you can create figures by running Dash apps or in other environments like Jupyter, your console, and more. 
* To see all of these rendering environments, see 

## Examples
###  in Dash

The `fig` object is passed directly into the `figure` property of `dcc.Graph`:

{{example express_graph}}

### Using the Low-Level Interface with 

Using the Low-Level Interface with 

Read through (1) above to learn more about the difference between  & .

{{example go_figure}}

### Using the Low-Level Interface with 



{{example figure_graph}}

## Interactive Graphing with Callbacks

[Interactive Visualizations](/interactive-graphing) in the Dash Fundamentals explains how to capture user interaction events with a `dcc.Graph`, and how to update the `figure` property in callbacks.

Some advanced features are documented in [community forum](https://community.plot.ly/) posts:
* How to preserve the UI state (zoom level etc.) of a Graph when updating the Graph in a callback https://community.plot.ly/t/preserving-ui-state-like-zoom-in-dcc-graph-with-uirevision/15793
* Graph transitions for smooth transitions or animations on Graph updates https://community.plot.ly/t/exploring-a-transitions-api-for-dcc-graph/15468

{{oss {{dash-club}} }}

## Controlling the Plotly.js Version Used by dcc.Graph

The `dcc.Graph` component leverages the [Plotly.js](https://plotly.com/javascript/) library to render
visualizations.

` component uses the version of the Plotly.js library in the Plotly.py version you have installed. Each version of Dash prior to 2.13 included its own version of Plotly.js.

If you want to use a different version of Plotly.js in Dash 2.13 or later, you can use a different version of Plotly.py. See the [Plotly.py releases page](https://github.com/plotly/plotly.py/releases) for more details on which version of Plotly.js was included with each release.

In all versions of Dash you can also override the Plotly.js version by placing a Plotly.js bundle in the [assets directory](/external-resources).

||julia|r

You can override the Plotly.js version by placing a Plotly.js bundle in the `assets` directory.

||fsharp

You can override the Plotly.js version by placing a Plotly.js bundle in the [`WebRoot` directory](/external-resources).

}}

This technique can be used to:
* take advantage of new features in a version of Plotly.js that is **more recent** than the one that is included in the currently installed version of Dash or Dash Design Kit.
* take advantage of more desirable behavior of a version of Plotly.js that is **less recent** than the one that is included in the currently installed version of Dash  or Dash Design Kit. We strive to make Plotly.js releases completely backwards-compatible, so you shouldn't have to do this very often.
* use [a Plotly-distributed Plotly.js partial bundle](https://github.com/plotly/plotly.js/blob/master/dist/README.md) or [a custom-built Plotly.js bundle](https://github.com/plotly/plotly.js/blob/master/BUILDING.md) which only includes the subset of Plotly.js features that your Dash app uses. Partial bundles are smaller than the full Plotly.js bundles that come with the `Graph` component  and can therefore improve your app's loading time.


## LaTeX

`dcc.Graph` supports rendering LaTeX on titles, labels, and annotations. It uses [MathJax version 3.2](https://docs.mathjax.org/en/v3.2-latest/) and can be enabled by setting `mathjax=True` on the component. Put content to be rendered with MathJax between `$` delimiters. If you need a literal `$`, use the HTML entity `&#36;`. To include text within MathJax delimiters, use `\text{<your_text_goes_here>}`. In the following example `(solar radius)` is included as text on the `yaxis_title`.

{{example mathjax_graph}}

> Rendering LaTeX is not currently supported on `hovertext`, `texttemplate`, `ticktext`, `text` on bar chart bars, or `labels` when displayed on pie charts. If you or your company would like to sponsor improvements to LaTeX rendering in Dash, get in touch with our [advanced development team](https://plotly.com/products/consulting-and-oem).

For an introduction to LaTeX math, see [LaTeX/Mathematics](https://en.wikibooks.org/wiki/LaTeX/Mathematics).

## Graph Resizing and Responsiveness

There are quite a few options that you can take advantage of if you want the size of your graph to be reactive.

The default `plotly.js` behavior dictates that the graph should resize upon window resize. However, in some cases, you might want to resize the graph based on the size of its parent container instead.
(You can set the size of the parent container with 

The  property of the `dcc.Graph` component allows you to define your desired behavior.
In short, it accepts as a value , :
*  forces the graph to be responsive to window and parent resize, regardless of any other specifications in  or 
*  forces the graph to be non-responsive to window and parent resize, regardless of any other specifications in  or 


### How Resizing Works - Advanced

The properties of `dcc.Graph` that can control the size of the graph (other than ) are:
*  - explicitly sets the height
* - explicitly sets the width
* , sets the height and width of the graph to that of its parent container
* , changes the height and width of the graph upon window resize.

The  property works in conjunction with the above properties in the following way:

* :  and 
 are overridden with  values, and 
 and  are unset
* :  and 
 are both overridden with  values


------------------------

{{reference dcc.Graph}}
