---
url: /dash-core-components/clipboard
name: Clipboard
description:
    "The dcc.Clipboard component enables users to copy text to the clipboard with a single click."
languages:
    - python
    - fsharp
    - matlab
---
# ![](/assets/images/language_icons/matlab_50px.svg) dcc.Clipboard

The `dcc.Clipboard` component copies text to the
user's clipboard with a single click.

## Examples

Find a few usage examples below.

### Simple Clipboard Example

The easiest way to trigger the copy is by using the `target_id` property.
No callback is required! Place `dcc.Clipboard` in the layout where
you would like the copy icon located. Specify the `target_id` of the component
with text to copy. In this example, the content of the `value` property of the
`dcc.Textarea` is copied to the clipboard.

{{example clipboard_textarea}}

### Clipboard Icon inside a Scrollable Div

The `style` and `className` can be used to change the design or the position
of the copy icon.  This example shows the icon placed in the top right corner
of a scrollable div.

{{example clipboard_markdown}}

### Updating the Clipboard Text in a Callback

When `target_id` is not specified, the content of the `text` property
is copied to the clipboard. This works well with components like the DataTable
where you may want to customize the text in a callback. In this example,


{{example clipboard_table}}

## Limitations

This component uses the[Clipboard API](https://developer.mozilla.org/en-US/docs/Web/API/Clipboard_API). This feature is available only in [secure contexts](https://developer.mozilla.org/en-US/docs/Web/Security/Secure_Contexts)
(HTTPS), in some or all [supporting browsers](https://developer.mozilla.org/en-US/docs/Web/API/Clipboard#browser_compatibility). When 
the Clipboard API is unavailable, the icon will not appear in the app and a warning message is
written to the console.

Currently `dcc.Clipboard` only supports copying text to the
clipboard. It does not support paste or other clipboard operations.

------------------------

{{reference dcc.Clipboard}}
